package cn.im.trafficplan.service;

 import cn.im.trafficplan.dao.TrafficplanexecmodeDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("trafficplanexecmodeService")
public class TrafficplanexecmodeService extends BaseService {
	
	private static final Log log = LogFactory.getLog(TrafficplanexecmodeService.class);
	
	@Autowired
	private TrafficplanexecmodeDao trafficplanexecmodeDao;
	
	/**
	 * ¼
	 */
	public void insert_Trafficplanexecmode(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		trafficplanexecmodeDao.insert_Trafficplanexecmode(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Trafficplanexecmode(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return trafficplanexecmodeDao.update_Trafficplanexecmode(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Trafficplanexecmode(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return trafficplanexecmodeDao.delete_Trafficplanexecmode(map);
	}
	
	

	/**
	 * planIDɾ¼
	 */
	public Integer delete_TrafficplanexecmodeByPlanID(String str) throws SQLException{
		if(str==null || str ==""){
			throw new SQLException("ɾޣ");
		}
		return trafficplanexecmodeDao.delete_TrafficplanexecmodeByPlanID(str);
	}
	
	
	/**
	 * Trafficplanexecmode ҳ
	 */
	public Map listTrafficplanexecmodeByPage(Map map) throws SQLException {
		List<Map> list = trafficplanexecmodeDao.query_Trafficplanexecmode(map);
		Integer totalCount = trafficplanexecmodeDao.count_Trafficplanexecmode(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * Trafficplanexecmode ҳ
	 */
	public List<Map> query_Trafficplanexecmode(Map map) throws SQLException {
		return trafficplanexecmodeDao.query_Trafficplanexecmode(map);
	}
	
	/**
	 * ༭ʼѯ
	 */
	public List<Map> query_Trafficplanexecmode_Origin(Map map) throws SQLException {
		return trafficplanexecmodeDao.query_Trafficplanexecmode_Origin(map);
	}
	
	/**
	 * Trafficplanexecmode ҳ
	 */
	public List<Map> query_Trafficplanexecmode_plan(Map map) throws SQLException {
		return trafficplanexecmodeDao.query_Trafficplanexecmode_plan(map);
	}
	
}
