package cn.im.trafficplan.action;

import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import cn.amq.basis.AmqConst;
import cn.amq.business.AmqMainPoint;
import cn.amq.peas.ClearVideoToWallHolder;
import cn.amq.peas.TrafficEventExecStateActionHolder;
import cn.amq.peas.TrafficEventLinkageActionHolder;
import cn.amq.peas.VideoToWallHolder;
import cn.amq.traffic.AmqTrafficEventLinkageActionService;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("amqTrafficLinkageDeviceAction")
public class AmqTrafficLinkageDeviceAction extends BaseAction{
	
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(AmqTrafficLinkageDeviceAction.class);
	
	/**
	 *  AMQ publish_TrafficEventExecState--״̬
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventExecState")
	public void publish_TrafficEventExecState(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventExecStateActionHolder action = new TrafficEventExecStateActionHolder();
			//TrafficEventExecStateAction action = new TrafficEventExecStateAction();
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("execState"))){
				action.setExecState(map.get("execState").toString());//豸ִ״̬룻 1δִУ2ִУ3ִгɹ4ִʧ
			}
			if(RHUtil.isNotEmpty(map.get("execTime"))){
				action.setExecTime(map.get("execTime").toString());//ִʱַʽYYYY-MM-DD HH24:MI:SS
			}
			if(RHUtil.isNotEmpty(map.get("createAppName"))){//
				action.setCreateAppName(map.get("createAppName").toString());
			}
			action.setCreateTime(DateUtil.currentDateTime());  //ʱ
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventExecStateAction);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventExecState()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 *  AMQ publish_TrafficEventLinkageAction-豸-鱨-յ
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventLinkageAction")
	public void publish_TrafficEventLinkageAction(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventLinkageActionHolder action = new TrafficEventLinkageActionHolder();
			//TrafficEventLinkageAction action = new TrafficEventLinkageAction();
			String eventId = "";
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("type"))){
				//action.setType(map.get("type").toString());
			}
			if(RHUtil.isNotEmpty(map.get("deviceInstruction"))){
				action.setDeviceInstruction(map.get("deviceInstruction").toString());
			}
			if(RHUtil.isNotEmpty(map.get("createAppName"))){
				action.setCreateAppName(map.get("createAppName").toString());
			}
			AmqTrafficEventLinkageActionService ata = new AmqTrafficEventLinkageActionService();
			ata.publishTrafficEventLinkageAction(action.getEventId(),action.getAlarmCode(),action.getDeviceType(),action.getDeviceId(),action.getDeviceInstruction());
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventLinkageAction()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 *  AMQ publish_VideoToWallǽ
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_VideoToWall")
	public void publish_VideoToWall(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			VideoToWallHolder action = new VideoToWallHolder();
			//VideoToWall action = new VideoToWall();
			if(RHUtil.isNotEmpty(map.get("type"))){
				//action.setType(map.get("type").toString());
			}
			if(RHUtil.isNotEmpty(map.get("alarmId"))){
				action.setGjbh(map.get("alarmId").toString());//澯id
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("alarmTime"))){
				action.setGjsj(map.get("alarmTime").toString());
			}
			if(RHUtil.isNotEmpty(map.get("alarmName"))){
				action.setGjmc(map.get("alarmName").toString());
			}
			if(RHUtil.isNotEmpty(map.get("fdId"))){
				action.setFdId(map.get("fdId").toString()); //
			}
			if(RHUtil.isNotEmpty(map.get("channelId"))){
				action.setTdbh(map.get("channelId").toString()); 
			}
			if(RHUtil.isNotEmpty(map.get("videoType"))){
				action.setVideoType(map.get("videoType").toString());
			}
			
			if(RHUtil.isNotEmpty(map.get("beginTime"))){
				action.setBeginTime(map.get("beginTime").toString());
			}			
			if(RHUtil.isNotEmpty(map.get("duration"))){
				action.setDuration(map.get("duration").toString());
			}
			if(RHUtil.isNotEmpty(map.get("wallId"))){
				action.setWallId(map.get("wallId").toString());
			}
			if(RHUtil.isNotEmpty(map.get("secnceId"))){
				action.setSecnceId(map.get("secnceId").toString());
			}
			if(RHUtil.isNotEmpty(map.get("winId"))){
				action.setWinId(map.get("winId").toString());
			}
			if(RHUtil.isNotEmpty(map.get("overlayText"))){
				action.setOverlayText(map.get("overlayText").toString());
			}
			if(RHUtil.isNotEmpty(map.get("jpgurl"))){
				action.setJpgurl(map.get("jpgurl").toString());
			}
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_VideoToWall);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_VideoToWall()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 *  AMQ ǽ
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_ClearVideoToWall")
	public void publish_ClearVideoToWall(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			ClearVideoToWallHolder action = new ClearVideoToWallHolder();
			//ClearVideoToWall action = new ClearVideoToWall();
			if(RHUtil.isNotEmpty(map.get("type"))){
				//action.setType(map.get("type").toString());
			}
			if(RHUtil.isNotEmpty(map.get("alarmId"))){
				action.setGjbh(map.get("alarmId").toString());//澯id
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("alarmTime"))){
				action.setGjsj(map.get("alarmTime").toString());
			}
			if(RHUtil.isNotEmpty(map.get("alarmName"))){
				action.setGjmc(map.get("alarmName").toString());
			}
			if(RHUtil.isNotEmpty(map.get("fdId"))){
				action.setFdId(map.get("fdId").toString()); //
			}
			if(RHUtil.isNotEmpty(map.get("channelId"))){
				action.setTdbh(map.get("channelId").toString()); 
			}
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_ClearVideoToWall);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_ClearVideoToWall()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 *  豸ִ״̬
	 *  AMQ publish_TrafficEventExecState--
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventExecState_yybb")
	public void publish_TrafficEventExecState_yybb(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventExecStateActionHolder action = new TrafficEventExecStateActionHolder();
			//TrafficEventExecStateAction action = new TrafficEventExecStateAction();
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("execState"))){
				action.setExecState(map.get("execState").toString());//豸ִ״̬룻 1δִУ2ִУ3ִгɹ4ִʧ
			}
			if(RHUtil.isNotEmpty(map.get("execTime"))){
				action.setExecTime(map.get("execTime").toString());//ִʱַʽYYYY-MM-DD HH24:MI:SS
			}
			if(RHUtil.isNotEmpty(map.get("createAppName"))){//
				action.setCreateAppName(map.get("createAppName").toString());
			}
			action.setCreateTime(DateUtil.currentDateTime());  //ʱ
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventExecStateAction);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventExecState_yybb()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 *  ƽ̨ͨ豸ִ״̬
	 *  AMQ publish_TrafficEventExecState--ƽ̨ͨ
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventExecState_pttx")
	public void publish_TrafficEventExecState_pttx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventExecStateActionHolder action = new TrafficEventExecStateActionHolder();
			//TrafficEventExecStateAction action = new TrafficEventExecStateAction();
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("execState"))){
				action.setExecState(map.get("execState").toString());//豸ִ״̬룻 1δִУ2ִУ3ִгɹ4ִʧ
			}
			if(RHUtil.isNotEmpty(map.get("execTime"))){
				action.setExecTime(map.get("execTime").toString());//ִʱַʽYYYY-MM-DD HH24:MI:SS
			}
			if(RHUtil.isNotEmpty(map.get("createAppName"))){//
				action.setCreateAppName(map.get("createAppName").toString());
			}
			action.setCreateTime(DateUtil.currentDateTime());  //ʱ
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventExecStateAction);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventExecState_pttx()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 *  ⱨ豸ִ״̬
	 *  AMQ publish_TrafficEventExecState--ⱨ
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventExecState_sgbj")
	public void publish_TrafficEventExecState_sgbj(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventExecStateActionHolder action = new TrafficEventExecStateActionHolder();
			//TrafficEventExecStateAction action = new TrafficEventExecStateAction();
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("execState"))){
				action.setExecState(map.get("execState").toString());//豸ִ״̬룻 1δִУ2ִУ3ִгɹ4ִʧ
			}
			if(RHUtil.isNotEmpty(map.get("execTime"))){
				action.setExecTime(map.get("execTime").toString());//ִʱַʽYYYY-MM-DD HH24:MI:SS
			}
			if(RHUtil.isNotEmpty(map.get("createAppName"))){//
				action.setCreateAppName(map.get("createAppName").toString());
			}
			action.setCreateTime(DateUtil.currentDateTime());  //ʱ
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventExecStateAction);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventExecState_sgbj()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 *  Ͷ֪ͨ豸ִ״̬
	 *  AMQ publish_TrafficEventExecState--֪ͨ
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventExecState_dxtz")
	public void publish_TrafficEventExecState_dxtz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventExecStateActionHolder action = new TrafficEventExecStateActionHolder();
			//TrafficEventExecStateAction action = new TrafficEventExecStateAction();
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("execState"))){
				action.setExecState(map.get("execState").toString());//豸ִ״̬룻 1δִУ2ִУ3ִгɹ4ִʧ
			}
			if(RHUtil.isNotEmpty(map.get("execTime"))){
				action.setExecTime(map.get("execTime").toString());//ִʱַʽYYYY-MM-DD HH24:MI:SS
			}
			if(RHUtil.isNotEmpty(map.get("createAppName"))){//
				action.setCreateAppName(map.get("createAppName").toString());
			}
			action.setCreateTime(DateUtil.currentDateTime());  //ʱ
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventExecStateAction);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventExecState_dxtz()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 *  豸ִ״̬
	 *  AMQ publish_TrafficEventExecState--
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventExecState_sdfj")
	public void publish_TrafficEventExecState_sdfj(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventExecStateActionHolder action = new TrafficEventExecStateActionHolder();
			//TrafficEventExecStateAction action = new TrafficEventExecStateAction();
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("execState"))){
				action.setExecState(map.get("execState").toString());//豸ִ״̬룻 1δִУ2ִУ3ִгɹ4ִʧ
			}
			if(RHUtil.isNotEmpty(map.get("execTime"))){
				action.setExecTime(map.get("execTime").toString());//ִʱַʽYYYY-MM-DD HH24:MI:SS
			}
			if(RHUtil.isNotEmpty(map.get("createAppName"))){//
				action.setCreateAppName(map.get("createAppName").toString());
			}
			action.setCreateTime(DateUtil.currentDateTime());  //ʱ
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventExecStateAction);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventExecState_sdfj()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 *  豸ִ״̬
	 *  AMQ publish_TrafficEventExecState--
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="publish_TrafficEventExecState_sdzm")
	public void publish_TrafficEventExecState_sdzm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			TrafficEventExecStateActionHolder action = new TrafficEventExecStateActionHolder();
			//TrafficEventExecStateAction action = new TrafficEventExecStateAction();
			if(RHUtil.isNotEmpty(map.get("eventId"))){
				action.setEventId(map.get("eventId").toString());//Ϣid
			}
			if(RHUtil.isNotEmpty(map.get("alarmCode"))){
				action.setAlarmCode(map.get("alarmCode").toString()); //¹ͱ
			}
			if(RHUtil.isNotEmpty(map.get("deviceType"))){
				action.setDeviceType(map.get("deviceType").toString()); //豸
			}
			if(RHUtil.isNotEmpty(map.get("deviceId"))){
				action.setDeviceId(map.get("deviceId").toString()); //豸ID豸id÷ֺŸLed鱨壺TrafficLedDeviceͨյƣTrafficLightDevice
			}
			if(RHUtil.isNotEmpty(map.get("execState"))){
				action.setExecState(map.get("execState").toString());//豸ִ״̬룻 1δִУ2ִУ3ִгɹ4ִʧ
			}
			if(RHUtil.isNotEmpty(map.get("execTime"))){
				action.setExecTime(map.get("execTime").toString());//ִʱַʽYYYY-MM-DD HH24:MI:SS
			}
			action.setCreateAppName("trafficLinkage");   //
			action.setCreateTime(DateUtil.currentDateTime());  //ʱ
			//holder.getList().add(action);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventExecStateAction);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("AmqTrafficLinkageDeviceAction-publish_TrafficEventExecState_sdzm()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
}
