package cn.im.ptxztree.service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.im.ptxztree.dao.PtxzsDao;
import cn.im.ptxztree.model.PtxzsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@Service("ptxzsService")
public class PtxzsService extends BaseService {
	
	private static final Log log = LogFactory.getLog(PtxzsService.class);
	
	@Autowired
	private PtxzsDao ptxzsDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptxzs(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptxzsDao.insert_Ptxzs(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptxzs(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptxzsDao.update_Ptxzs(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptxzs(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptxzsDao.delete_Ptxzs(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptxzs(Map map) throws SQLException{
		return ptxzsDao.batch_delete_Ptxzs(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptxzs(Map map) throws SQLException{
		return ptxzsDao.count_Ptxzs(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptxzs(Map map) throws SQLException{
		return ptxzsDao.query_Ptxzs(map);
	}
	public List<Map> query_PtxzsTree(Map map) throws SQLException{
		return ptxzsDao.query_PtxzsTree(map);
	}



	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptxzs(Map map) throws SQLException{
		return ptxzsDao.get_Ptxzs(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtxzs(Map map) throws SQLException{
		return this.listPtxzsByPage(map);
	}
	
	/**
	 * Ptxzs ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtxzsByPage(Map map) throws SQLException {
		List<Map> list = ptxzsDao.query_Ptxzs(map);
		Integer totalCount = ptxzsDao.count_Ptxzs(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	/**
	 * Ptxzs ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public List<Map> listPtxzs(Map map) throws SQLException {
		return ptxzsDao.listPtxzs(map);
	}


}
