package cn.im.ptdlfw.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.im.ptdlfw.dao.PtdlfwDao;

@Service("ptdlfwService")
public class PtdlfwService extends BaseService {
	
	private static final Log log = LogFactory.getLog(PtdlfwService.class);
	
	@Autowired
	private PtdlfwDao ptdlfwDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptdlfw(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptdlfwDao.insert_Ptdlfw(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptdlfw(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptdlfwDao.update_Ptdlfw(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptdlfw(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptdlfwDao.delete_Ptdlfw(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptdlfw(Map map) throws SQLException{
		return ptdlfwDao.batch_delete_Ptdlfw(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptdlfw(Map map) throws SQLException{
		return ptdlfwDao.count_Ptdlfw(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptdlfw(Map map) throws SQLException{
		return ptdlfwDao.query_Ptdlfw(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptdlfw(Map map) throws SQLException{
		return ptdlfwDao.get_Ptdlfw(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtdlfw(Map map) throws SQLException{
		return this.listPtdlfwByPage(map);
	}
	
	/**
	 * Ptdlfw ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtdlfwByPage(Map map) throws SQLException {
		List<Map> list = ptdlfwDao.query_Ptdlfw(map);
		Integer totalCount = ptdlfwDao.count_Ptdlfw(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
