package cn.im.che.service;

 import cn.im.che.dao.ClxxgpsDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("clxxgpsService")
public class ClxxgpsService extends BaseService {
	
	private static final Log log = LogFactory.getLog(ClxxgpsService.class);
	
	@Autowired
	private ClxxgpsDao clxxgpsDao;
	
	/**
	 * ¼
	 */
	public void insert_Clxxgps(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		clxxgpsDao.insert_Clxxgps(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Clxxgps(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return clxxgpsDao.update_Clxxgps(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Clxxgps(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return clxxgpsDao.delete_Clxxgps(map);
	}

	/**
	 * Clxxgps ҳ
	 */
	public Map listClxxgpsByPage(Map map) throws SQLException {
		List<Map> list = clxxgpsDao.query_Clxxgps(map);
		Integer totalCount = clxxgpsDao.count_Clxxgps(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * Clxxgps ҳ
	 */
	public List<Map> query_Clxxgps(Map map) throws SQLException {
		return clxxgpsDao.query_Clxxgps(map);
	}
}
