package cn.bsystem.ptuserrole.service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.StringUtil;
import cn.bsystem.ptuserrole.dao.PtyhDao;
import cn.bsystem.ptuserrole.dao.PtyhbmDao;
import cn.bsystem.ptuserrole.dao.PtyhbmscbfDao;
import cn.bsystem.ptuserrole.dao.PtyhcdjsDao;
import cn.bsystem.ptuserrole.dao.PtyhhmdlDao;
import cn.bsystem.ptuserrole.dao.PtyhscbfDao;
import cn.bsystem.ptuserrole.dao.SbtdjqqxDao;
import cn.bsystem.ptuserrole.dao.SbtdtpqxDao;

@Service("ptyhbmService")
public class PtyhbmService extends BaseService {
	
	private static final Log log = LogFactory.getLog(PtyhbmService.class);
	
	@Autowired
	private PtyhbmDao ptyhbmDao;
	
	@Autowired
	private PtyhbmscbfDao ptyhbmscbfDao;
	
	@Autowired
	private PtyhDao ptyhDao;
	
	@Autowired
	private PtyhscbfDao ptyhscbfDao;
	
	@Autowired
	private PtyhhmdlDao ptyhhmdlDao;
	
	@Autowired
	private PtyhcdjsDao ptyhcdjsDao;
	
	@Autowired
	private SbtdjqqxDao sbtdjqqxDao;
	
	@Autowired
	private SbtdtpqxDao sbtdtpqxDao;
	
	
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptyhbm(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptyhbmDao.insert_Ptyhbm(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptyhbm(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptyhbmDao.update_Ptyhbm(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptyhbm(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		Map mm = new HashMap();
		if(!(StringUtil.checkEmpty(map.get("khbh"))||StringUtil.checkEmpty(map.get("bmbh")))){
			mm.put("khbh", map.get("khbh"));
			mm.put("bmbh", map.get("bmbh"));
			Map ptyhbmMap = get_Ptyhbm(mm);
			if(StringUtil.checkEmpty(ptyhbmMap.get("xh"))){
				ptyhbmMap.put("xh", StringUtil.getUUID());
			}
			//
			//1.ƽ̨ûɾ	ptyhbmscbf
			ptyhbmscbfDao.insert_Ptyhbmscbf(ptyhbmMap);
			List ptyhList = ptyhDao.query_Ptyh(mm);
			for(int i=0;i<ptyhList.size();i++){
				Map ptyhMap = (Map)ptyhList.get(i);
				if(StringUtil.checkEmpty(ptyhMap.get("xh"))){
					ptyhMap.put("xh", StringUtil.getUUID());
					//
					//1.ƽ̨ûɾ	ptyhscbf
					ptyhscbfDao.insert_Ptyhscbf(ptyhMap);
				}
				if(!StringUtil.checkEmpty(ptyhMap.get("yhzh"))){
					Map delMap = new  HashMap();
					delMap.put("yhzh", ptyhMap.get("yhzh"));
					//2ƽ̨û˵ɫ	ptyhcdjs
					ptyhhmdlDao.delete_Ptyhhmdl(delMap);
				}
				if(!StringUtil.checkEmpty(ptyhMap.get("yhbh"))){
					Map delMap = new  HashMap();
					delMap.put("yhbh", ptyhMap.get("yhbh"));
					//3.ƽ̨ûĤ¼	ptyhhmdl	
					ptyhcdjsDao.delete_Ptyhcdjs(delMap);
					//1.ƽ̨û			ptyh
					ptyhDao.delete_Ptyh(delMap);
				}
			}	
			//2.豸ͨȷȨ	sbtdjqqx
			sbtdjqqxDao.delete_Sbtdjqqx(mm);			
			//3.豸ͨͨȨ	sbtdtpqx
			sbtdtpqxDao.delete_Sbtdtpqx(mm);
		}
		return ptyhbmDao.delete_Ptyhbm(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptyhbm(Map map) throws SQLException{
		return ptyhbmDao.batch_delete_Ptyhbm(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptyhbm(Map map) throws SQLException{
		return ptyhbmDao.count_Ptyhbm(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptyhbm(Map map) throws SQLException{
		return ptyhbmDao.query_Ptyhbm(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptyhbm(Map map) throws SQLException{
		return ptyhbmDao.get_Ptyhbm(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtyhbm(Map map) throws SQLException{
		return this.listPtyhbmByPage(map);
	}
	
	/**
	 * Ptyhbm ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtyhbmByPage(Map map) throws SQLException {
		List<Map> list = ptyhbmDao.query_Ptyhbm(map);
		Integer totalCount = ptyhbmDao.count_Ptyhbm(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * Ptyhbm ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map query_ptyhbm_ext(Map map) throws SQLException {
		List<Map> list = ptyhbmDao.query_ptyhbm_ext(map);
		Integer totalCount = ptyhbmDao.count_ptyhbm_ext(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

	public List query_alldept(Map mp)throws Exception {
		return ptyhbmDao.getAlldept(mp);
	}
	public List query_ptyhdepart_ext(Map mp)throws Exception {
		return ptyhbmDao.query_ptyhdepart_ext(mp);
	}
	public List querydepartidsByyhbh(Map mp)throws Exception {
		return ptyhbmDao.querydepartidsByyhbh(mp);
	}


}
