package cn.bsystem.ptuserrole.service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.StringUtil;
import cn.bsystem.ptuserrole.dao.PtyhDao;
import cn.bsystem.ptuserrole.dao.PtyhcdjsDao;
import cn.bsystem.ptuserrole.dao.PtyhhmdlDao;
import cn.bsystem.ptuserrole.dao.PtyhscbfDao;

@Service("ptyhService")
public class PtyhService extends BaseService {
	
	private static final Log log = LogFactory.getLog(PtyhService.class);
	
	@Autowired
	private PtyhDao ptyhDao;//ע
	
	@Autowired
	private PtyhscbfDao ptyhscbfDao;
	
	@Autowired
	private PtyhhmdlDao ptyhhmdlDao;
	
	@Autowired
	private PtyhcdjsDao ptyhcdjsDao;
	

	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptyh(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptyhDao.insert_Ptyh(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptyh(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptyhDao.update_Ptyh(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptyh(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		Map mm = new HashMap();
		//ûɾŻ
		if(!StringUtil.checkEmpty(map.get("yhbh"))){
			mm.put("yhbh", map.get("yhbh"));
			Map ptyhMap = get_Ptyh(mm);
			if(StringUtil.checkEmpty(ptyhMap.get("xh"))){
				ptyhMap.put("xh", StringUtil.getUUID());
			}
			//ɾʱݵݱ
			ptyhscbfDao.insert_Ptyhscbf(ptyhMap);
			if(!StringUtil.checkEmpty(ptyhMap.get("yhzh"))){
				Map delMap = new  HashMap();
				delMap.put("yhzh", ptyhMap.get("yhzh"));
				//3.ƽ̨ûĤ¼	ptyhhmdl
				ptyhhmdlDao.delete_Ptyhhmdl(delMap);
			}
			if(!StringUtil.checkEmpty(ptyhMap.get("yhbh"))){
				Map delMap = new  HashMap();
				delMap.put("yhbh", ptyhMap.get("yhbh"));
				//2ƽ̨û˵ɫ	ptyhcdjs
				ptyhcdjsDao.delete_Ptyhcdjs(delMap);
			}
		}	
		return ptyhDao.delete_Ptyh(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptyh(Map map) throws SQLException{
		return ptyhDao.batch_delete_Ptyh(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptyh(Map map) throws SQLException{
		return ptyhDao.count_Ptyh(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptyh(Map map) throws SQLException{
		return ptyhDao.query_Ptyh(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public Map query_ptyh_ext(Map map) throws SQLException{
		List<Map> list = ptyhDao.query_ptyh_ext(map);
		Integer totalCount = ptyhDao.count_ptyh_ext(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptyh(Map map) throws SQLException{
		return ptyhDao.get_Ptyh(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtyh(Map map) throws SQLException{
		return this.listPtyhByPage(map);
	}
	
	/**
	 * Ptyh ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtyhByPage(Map map) throws SQLException {
		List<Map> list = ptyhDao.query_Ptyh(map);
		Integer totalCount = ptyhDao.count_Ptyh(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * Ptyh ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtyh_sbqx_ByPage(Map map) throws SQLException {
		List<Map> list = ptyhDao.query_Ptyh_sbqx(map);
		Integer totalCount = ptyhDao.count_Ptyh(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * Ptyh ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtyh_sbjqqx_ByPage(Map map) throws SQLException {
		List<Map> list = ptyhDao.query_ptyh_sbjqqx(map);
		Integer totalCount = ptyhDao.count_ptyh_sbjqqx(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * Ptyh ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtyh_sbtpqx_ByPage(Map map) throws SQLException {
		List<Map> list = ptyhDao.query_ptyh_sbtpqx(map);
		Integer totalCount = ptyhDao.count_ptyh_sbtpqx(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public Integer deletePtyhByYhbh(Map map) throws SQLException{
		return ptyhDao.deletePtyhByYhbh(map);
	}

	public void insert_Ptyhdepart(List list) throws SQLException{
		ptyhDao.insert_Ptyhdepart(list);
	}


}
