package cn.bsystem.ptlog.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.bsystem.ptlog.dao.PtyhczrzDao;

@Service("ptyhczrzService")
public class PtyhczrzService extends BaseService {
	
	private static final Log log = LogFactory.getLog(PtyhczrzService.class);
	
	@Autowired
	private PtyhczrzDao ptyhczrzDao;
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptyhczrz(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptyhczrzDao.insert_Ptyhczrz(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptyhczrz(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptyhczrzDao.update_Ptyhczrz(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptyhczrz(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptyhczrzDao.delete_Ptyhczrz(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptyhczrz(Map map) throws SQLException{
		return ptyhczrzDao.batch_delete_Ptyhczrz(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptyhczrz(Map map) throws SQLException{
		return ptyhczrzDao.count_Ptyhczrz(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptyhczrz(Map map) throws SQLException{
		return ptyhczrzDao.query_Ptyhczrz(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptyhczrz(Map map) throws SQLException{
		return ptyhczrzDao.get_Ptyhczrz(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtyhczrz(Map map) throws SQLException{
		return this.listPtyhczrzByPage(map);
	}
	
	/**
	 * Ptyhczrz ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtyhczrzByPage(Map map) throws SQLException {
		List<Map> list = ptyhczrzDao.query_Ptyhczrz(map);
		Integer totalCount = ptyhczrzDao.count_Ptyhczrz(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
