package cn.bsystem.ptConst.service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.bsystem.ptConst.dao.XtclDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;



@Service("xtclService")
public class XtclService extends BaseService {
	
	private static final Log log = LogFactory.getLog(XtclService.class);
	
	@Autowired
	private XtclDao xtclDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Xtcl(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		xtclDao.insert_Xtcl(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Xtcl(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return xtclDao.update_Xtcl(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Xtcl(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return xtclDao.delete_Xtcl(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Xtcl(Map map) throws SQLException{
		return xtclDao.batch_delete_Xtcl(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Xtcl(Map map) throws SQLException{
		return xtclDao.count_Xtcl(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Xtcl(Map map) throws SQLException{
		return xtclDao.query_Xtcl(map);
	}
	public List<Map> query_Xtcl_task(Map map) throws SQLException{
		return xtclDao.query_Xtcl_task(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Xtcl(Map map) throws SQLException{
		return xtclDao.get_Xtcl(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportXtcl(Map map) throws SQLException{
		return this.listXtclByPage(map);
	}
	
	/**
	 * Xtcl ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listXtclByPage(Map map) throws SQLException {
		List<Map> list = xtclDao.query_Xtcl(map);
		Integer totalCount = xtclDao.count_Xtcl(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

	public List<Map> query_Xtcl_alarm(Map map) throws SQLException{
		return xtclDao.query_Xtcl_alarm(map);
	}
}
