
package cn.base.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ĸ
 * 
 * @author redhigh
 * @since 2013-12-04
 */
public class RHUtil {
	private static final Log log = LogFactory.getLog(RHUtil.class);
	/**
	 * DES㷨Կ
	 */
	private static final byte[] DES_KEY = { 21, 1, -110, 82, -32, -85, -128, -65 };
	private static final String[] HanDigiStr = new String[] { "", "Ҽ", "", "", "", "", "½", "", "", "" };
	private static final String[] HanDiviStr = new String[] { "", "ʰ", "", "Ǫ", "", "ʰ", "", "Ǫ", "", "ʰ", "", "Ǫ", "",
			"ʰ", "", "Ǫ", "", "ʰ", "", "Ǫ", "", "ʰ", "", "Ǫ" };
	/**
	 * ж϶ǷEmpty(nullԪΪ0)<br>
	 * ʵڶ¶ж:String Collection Map
	 * @param pObj 
	 * @return boolean صĲֵ
	 */
	public static boolean isEmpty(Object pObj) {
		if (pObj == null)
			return true;
		if (pObj.equals(""))
			return true;
		if (pObj instanceof String) {
            return ((String) pObj).length() == 0;
		} else if (pObj instanceof Collection) {
            return ((Collection) pObj).size() == 0;
		} else if (pObj instanceof Map) {
            return ((Map) pObj).size() == 0;
		}
		return false;
	}
	/**
	 * ж϶ǷΪNotEmpty(!nullԪ>0)<br>
	 * ʵڶ¶ж:String Collection Map
	 * @param pObj 
	 * @return boolean صĲֵ
	 */
	public static boolean isNotEmpty(Object pObj) {
		if (pObj == null)
			return false;
		if (pObj.equals(""))
			return false;
		if (pObj instanceof String) {
            return ((String) pObj).length() != 0;
		} else if (pObj instanceof Collection) {
            return ((Collection) pObj).size() != 0;
		} else if (pObj instanceof Map) {
            return ((Map) pObj).size() != 0;
		}
		return true;
	}
	/**
	 * жһַǷ֡ĸĸ
	 * @param pStr Ҫжϵַ
	 * @param pStyle жϹ
	 * @return boolean صĲֵ
	 */
	public static boolean isTheStyle(String pStr, String pStyle) {
		for (int i = 0; i < pStr.length(); i++) {
			char c = pStr.charAt(i);
			if (pStyle.equals("number")) {
				if (!Character.isDigit(c))
					return false;
			} else if (pStyle.equals("letter")) {
				if (!Character.isLetter(c))
					return false;
			} else if (pStyle.equals("numberletter")) {
				if (Character.isLetterOrDigit(c))
					return false;
			}
		}
		return true;
	}
	/**
	 * JavaBeanֵ֮
	 * @param pFromObj BeanԴ
	 * @param pToObj BeanĿ
	 */
	public static void copyPropBetweenBeans(Object pFromObj, Object pToObj) {
		if (pToObj != null) {
			try {
				BeanUtils.copyProperties(pToObj, pFromObj);
			} catch (Exception e) {
				log.error("==Աע:==\n JavaBeanֵ֮!" + "\nϸϢ:");
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * ֤У飬һӦ18λ֤
	 * @param personIDCode ֤
	 * @return String ʮλ֤
	 * @throws Ч֤
	 */
	public static String getFixedPersonIDCode(String personIDCode) throws Exception {
		if (personIDCode == null)
			throw new Exception("֤Ч");
		if (personIDCode.length() == 18) {
			if (isIdentity(personIDCode))
				return personIDCode;
			else
				throw new Exception("֤Ч");
		} else if (personIDCode.length() == 15)
			return fixPersonIDCodeWithCheck(personIDCode);
		else
			throw new Exception("֤Ч");
	}
	/**
	 * ޲15λ֤Ϊ18λУ15λ֤Ч
	 * @param personIDCode ʮλ֤
	 * @return String ʮλ֤
	 * @throws Ч֤
	 */
	public static String fixPersonIDCodeWithCheck(String personIDCode) throws Exception {
		if (personIDCode == null || personIDCode.trim().length() != 15)
			throw new Exception("֤Ų15λ");

		if (!isIdentity(personIDCode))
			throw new Exception("֤Ч");

		return fixPersonIDCodeWithoutCheck(personIDCode);
	}
	/**
	 * ޲15λ֤Ϊ18λУ֤Ч
	 * @param personIDCode ʮλ֤
	 * @return ʮλ֤
	 * @throws ֤Ų15λ
	 */
	public static String fixPersonIDCodeWithoutCheck(String personIDCode) throws Exception {
		if (personIDCode == null || personIDCode.trim().length() != 15)
			throw new Exception("֤Ų15λ");
		String id17 = personIDCode.substring(0, 6) + "19" + personIDCode.substring(6, 15); // 15λ֤'19'
		char[] code = { '1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2' }; // 11Уַ
		int[] factor = { 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1 }; // 18Ȩ
		int[] idcd = new int[18];
		int sum; // ݹʽ (aiWi) 
		int remainder; // 18λУ
		for (int i = 0; i < 17; i++) {
			idcd[i] = Integer.parseInt(id17.substring(i, i + 1));
		}
		sum = 0;
		for (int i = 0; i < 17; i++) {
			sum = sum + idcd[i] * factor[i];
		}
		remainder = sum % 11;
		String lastCheckBit = String.valueOf(code[remainder]);
		return id17 + lastCheckBit;
	}
	/**
	 * жǷЧ18λ15λ֤
	 * @param identity 18λ15λ֤
	 * @return ǷΪЧ֤
	 */
	public static boolean isIdentity(String identity) {
		if (identity == null)
			return false;
		if (identity.length() == 18 || identity.length() == 15) {
			String id15 = null;
			if (identity.length() == 18)
				id15 = identity.substring(0, 6) + identity.substring(8, 17);
			else
				id15 = identity;
			try {
				Long.parseLong(id15); // УǷΪַ
				String birthday = "19" + id15.substring(6, 12);
				SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
				sdf.parse(birthday); // У
				if (identity.length() == 18 && !fixPersonIDCodeWithoutCheck(id15).equals(identity))
					return false; // У18λ֤
			} catch (Exception e) {
				return false;
			}
			return true;
		} else
			return false;
	}
	/**
	 * ֤лȡڣ֤ſΪ15λ18λ
	 * @param identity ֤
	 * @return 
	 * @throws ֤ųڶ
	 */
	public static Timestamp getBirthdayFromPersonIDCode(String identity) throws Exception {
		String id = getFixedPersonIDCode(identity);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
		try {
			Timestamp birthday = new Timestamp(sdf.parse(id.substring(6, 14)).getTime());
			return birthday;
		} catch (ParseException e) {
			throw new Exception("Ч֤ţ");
		}
	}
	/**
	 * ֤ŻȡԱ
	 * @param identity ֤
	 * @return Ա
	 * @throws Exception
	 *             Ч֤
	 */
	public static String getGenderFromPersonIDCode(String identity) throws Exception {
		String id = getFixedPersonIDCode(identity);
		char sex = id.charAt(16);
		return sex % 2 == 0 ? "2" : "1";
	}
	/**
	 * תΪдʽ(ڲ)
	 * @param val
	 * @return String
	 */
	private static String PositiveIntegerToHanStr(String NumStr) {
		// ַֻǰո(Ҷ)ǰ
		String RMBStr = "";
		boolean lastzero = false;
		boolean hasvalue = false; // ڡλǰֵ
		int len, n;
		len = NumStr.length();
		if (len > 15)
			return "ֵ!";
		for (int i = len - 1; i >= 0; i--) {
			if (NumStr.charAt(len - i - 1) == ' ')
				continue;
			n = NumStr.charAt(len - i - 1) - '0';
			if (n < 0 || n > 9)
				return "뺬ַ!";
			if (n != 0) {
				if (lastzero)
					RMBStr += HanDigiStr[0]; // ֵֻʾһ
				// ǰ㲻
				// if( !( n==1 && (i%4)==1 && (lastzero || i==len-1) ) )
				// ʮλǰҲҼô
				if (!(n == 1 && (i % 4) == 1 && i == len - 1)) // ʮλڵһλҼ
					RMBStr += HanDigiStr[n];
				RMBStr += HanDiviStr[i]; // ֵӽλλΪ
				hasvalue = true; // λǰֵ
			} else {
				if ((i % 8) == 0 || ((i % 8) == 4 && hasvalue)) // ֮зֵʾ
					RMBStr += HanDiviStr[i]; // ڡ
			}
			if (i % 8 == 0)
				hasvalue = false; // λǰֵǷڸλ
			lastzero = (n == 0) && (i % 4 != 0);
		}
		if (RMBStr.length() == 0)
			return HanDigiStr[0]; // ַ"0"""
		return RMBStr;
	}
	/**
	 * תΪдʽ
	 * @param val 
	 * @return String صҴдʽַ
	 */
	public static String numToRMBStr(double val) {
		String SignStr = "";
		String TailStr = "";
		long fraction, integer;
		int jiao, fen;
		if (val < 0) {
			val = -val;
			SignStr = "";
		}
		if (val > 99999999999999.999 || val < -99999999999999.999)
			return "ֵλ!";
		// 뵽
		long temp = Math.round(val * 100);
		integer = temp / 100;
		fraction = temp % 100;
		jiao = (int) fraction / 10;
		fen = (int) fraction % 10;
		if (jiao == 0 && fen == 0) {
			TailStr = "";
		} else {
			TailStr = HanDigiStr[jiao];
			if (jiao != 0)
				TailStr += "";
			// Ԫд㼸
			if (integer == 0 && jiao == 0)
				TailStr = "";
			if (fen != 0)
				TailStr += HanDigiStr[fen] + "";
		}
		// һпڷڳϣ0.03ֻʾ֡ǡԪ֡
		// if( !integer ) return SignStr+TailStr;
		return SignStr + PositiveIntegerToHanStr(String.valueOf(integer)) + "Ԫ" + TailStr;
	}
	/**
	 * ȡָݺ·ݶӦ
	 * @param year ָ
	 * @param month ָ·
	 * @return int 
	 */
	public static int getDaysInMonth(int year, int month) {
		if ((month == 1) || (month == 3) || (month == 5) || (month == 7) || (month == 8) || (month == 10)
				|| (month == 12)) {
			return 31;
		} else if ((month == 4) || (month == 6) || (month == 9) || (month == 11)) {
			return 30;
		} else {
			if (((year % 4) == 0) && ((year % 100) != 0) || ((year % 400) == 0)) {
				return 29;
			} else {
				return 28;
			}
		}
	}
	/**
	 * ֹʱ
	 * @param startDate  ʼʱ
	 * @param endDate ʱ
	 * @return int ؼ
	 */
	public static int getIntervalDays(java.sql.Date startDate, java.sql.Date endDate) {
		long startdate = startDate.getTime();
		long enddate = endDate.getTime();
		long interval = enddate - startdate;
		int intervalday = (int) (interval / (1000 * 60 * 60 * 24));
		return intervalday;
	}
	/**
	 * ֹʱ
	 * @param startDate  ʼʱ
	 * @param endDate ʱ
	 * @return int ؼ
	 */
	public static int getIntervalMonths(java.sql.Date startDate, java.sql.Date endDate) {
		Calendar startCal = Calendar.getInstance();
		startCal.setTime(startDate);
		Calendar endCal = Calendar.getInstance();
		endCal.setTime(endDate);
		int startDateM = Calendar.MONTH;
		int startDateY = Calendar.YEAR;
		int enddatem = Calendar.MONTH;
		int enddatey = Calendar.YEAR;
		int interval = (enddatey * 12 + enddatem) - (startDateY * 12 + startDateM);
		return interval;
	}
	/**
	 * صǰʱַ<br>
	 * Ĭϸʽ:yyyy-mm-dd hh:mm:ss
	 * @return String صǰַʱ
	 */
	public static String getCurrentTime() {
		String returnStr = null;
		SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date date = new Date();
		returnStr = f.format(date);
		return returnStr;
	}
	/**
	 * Զʽĵǰʱַ
	 * @param format ʽ
	 * @return String صǰַʱ
	 */
	public static String getCurrentTime(String format) {
		String returnStr = null;
		SimpleDateFormat f = new SimpleDateFormat(format);
		Date date = new Date();
		returnStr = f.format(date);
		return returnStr;
	}
	/**
	 * صǰַ
	 * @return String صַ
	 */
	public static String getCurDate() {
		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyy-MM-dd");
		String strDate = simpledateformat.format(calendar.getTime());
		return strDate;
	}
	/**
	 * صǰַ
	 * @return String صַ
	 */
	public static String getCutDateTime() {
		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMdd");
		String strDate = simpledateformat.format(calendar.getTime());
		return strDate;
	}
	/**
	 * ַתΪ
	 * @param strDate ַ
	 * @param srcDateFormat Դڸʽ
	 * @param dstDateFormat Ŀڸʽ
	 * @return Date صutil.Date
	 */
	public static Date stringToDate(String strDate, String srcDateFormat, String dstDateFormat) {
		Date rtDate = null;
		Date tmpDate = (new SimpleDateFormat(srcDateFormat)).parse(strDate, new ParsePosition(0));
		String tmpString = null;
		if (tmpDate != null)
			tmpString = (new SimpleDateFormat(dstDateFormat)).format(tmpDate);
		if (tmpString != null)
			rtDate = (new SimpleDateFormat(dstDateFormat)).parse(tmpString, new ParsePosition(0));
		return rtDate;
	}
	/**
	 * ϲַ
	 * @param a  ַ0
	 * @param b  ַ1
	 * @return غϲַ
	 */
	public static String[] mergeStringArray(String[] a, String[] b) {
		if (a.length == 0 || isEmpty(a))
			return b;
		if (b.length == 0 || isEmpty(b))
			return a;
		String[] c = new String[a.length + b.length];
		for (int m = 0; m < a.length; m++) {
			c[m] = a[m];
		}
		for (int i = 0; i < b.length; i++) {
			c[a.length + i] = b[i];
		}
		return c;
	}
	/**
	 * ļصļб θ汾Ĳ
	 */
	public static String encodeChineseDownloadFileName(HttpServletRequest request, String pFileName) {
		String agent = request.getHeader("USER-AGENT");
		try {
			if (null != agent && -1 != agent.indexOf("MSIE")) {
				pFileName = URLEncoder.encode(pFileName, "utf-8");
			} else {
				pFileName = new String(pFileName.getBytes(StandardCharsets.UTF_8), "iso8859-1");
			}
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return pFileName;
	}
	/**
	 * ڻȡ
	 * @param strdate
	 * @return
	 */
	public static String getWeekDayByDate(String strdate) {
		final String[] dayNames = { "", "һ", "ڶ", "", "", "", "" };
		SimpleDateFormat sdfInput = new SimpleDateFormat("yyyy-MM-dd");
		Calendar calendar = Calendar.getInstance();
		Date date = new Date();
		try {
			date = sdfInput.parse(strdate);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		calendar.setTime(date);
		int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK) - 1;
		if (dayOfWeek < 0)
			dayOfWeek = 0;
		return dayNames[dayOfWeek];
	}
	/**
	 * жǷIE
	 * @param userAgent
	 * @return
	 */
	public static boolean isIE(HttpServletRequest request) {
		String userAgent = request.getHeader("USER-AGENT").toLowerCase();
		boolean isIe = true;
		int index = userAgent.indexOf("msie");
		if (index == -1) {
			isIe = false;
		}
		return isIe;
	}
	/**
	 * жǷChrome
	 * @param userAgent
	 * @return
	 */
	public static boolean isChrome(HttpServletRequest request) {
		String userAgent = request.getHeader("USER-AGENT").toLowerCase();
		boolean isChrome = true;
		int index = userAgent.indexOf("chrome");
		if (index == -1) {
			isChrome = false;
		}
		return isChrome;
	}
	/**
	 * жǷFirefox
	 * @param userAgent
	 * @return
	 */
	public static boolean isFirefox(HttpServletRequest request) {
		String userAgent = request.getHeader("USER-AGENT").toLowerCase();
		boolean isFirefox = true;
		int index = userAgent.indexOf("firefox");
		if (index == -1) {
			isFirefox = false;
		}
		return isFirefox;
	}
	/**
	 * ȡͻ
	 * 
	 * @param userAgent
	 * @return
	 */
	public static String getClientExplorerType(HttpServletRequest request) {
		String userAgent = request.getHeader("USER-AGENT").toLowerCase();
		String explorer = "";
		if (isIE(request)) {
			int index = userAgent.indexOf("msie");
			explorer = userAgent.substring(index, index + 8);
		} else if (isChrome(request)) {
			int index = userAgent.indexOf("chrome");
			explorer = userAgent.substring(index, index + 12);
		} else if (isFirefox(request)) {
			int index = userAgent.indexOf("firefox");
			explorer = userAgent.substring(index, index + 11);
		}
		return explorer.toUpperCase();
	}
	
	/**
	 * жJDBCͣOracle
	 * @return
	 */
	public static boolean isOracle() {
		boolean out = false;
		/*
		String jdbcType = pHelper.getValue("jdbcType");
		if (jdbcType.equalsIgnoreCase("oracle")) {
			out = true;
		}
		*/
		return out;
	}
	/**
	 * жJDBCͣMysql
	 * @return
	 */
	public static boolean isMysql() {
		boolean out = false;
		/*
		String jdbcType = pHelper.getValue("jdbcType");
		if (jdbcType.equalsIgnoreCase("mysql")) {
			out = true;
		}
		*/
		return out;
	}	
	public static String byte2HexString(byte[] b) {
        char[] hex = {'0', '1', '2', '3', '4', '5', '6', '7',
            '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] newChar = new char[b.length * 2];
        for (int i = 0; i < b.length; i++) {
            newChar[2 * i] = hex[(b[i] & 0xf0) >> 4];
            newChar[2 * i + 1] = hex[b[i] & 0xf];
        }
        return new String(newChar);
    }
    public static byte[] hexString2ByteArray(String hexString) {
        char[] chars = hexString.toCharArray();
        byte[] b = new byte[chars.length / 2];
        for (int i = 0; i < b.length; i++) {
            int high = Character.digit(chars[2 * i], 16) << 4;
            int low = Character.digit(chars[2 * i + 1], 16);
            b[i] = (byte) (high | low);
        }
        return b;
    }
    /**
	 * ȡclassļھ·
	 * 
	 * @param cls
	 * @return
	 * @throws IOException
	 */
	public static String getPathFromClass(Class cls) {
		String path = null;
		if (cls == null) {
			throw new NullPointerException();
		}
		URL url = getClassLocationURL(cls);
		if (url != null) {
			path = url.getPath();
			if ("jar".equalsIgnoreCase(url.getProtocol())) {
				try {
					path = new URL(path).getPath();
				} catch (MalformedURLException e) {
				}
				int location = path.indexOf("!/");
				if (location != -1) {
					path = path.substring(0, location);
				}
			}
			File file = new File(path);
			try {
				path = file.getCanonicalPath();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return path;
	}
	
    /**
	 * ͨĳclassļ·ȡļĿ¼ľ· ͨڳкѶλĳ·رB/SӦС
	 * ͨǿԸǳļλλĳ·
	 * 磺ĳtxtļڳTestļ·../../resource/test.txt
	 * ôʹñPath.getFullPathRelateClass("../../resource/test.txt",Test.class)
	 * õĽtxtļϵͳеľ·
	 * 
	 * @param relatedPath
	 *            ·
	 * @param cls
	 *            λ
	 * @return ·Ӧľ·
	 * @throws IOException
	 *             ΪѯļϵͳԿ׳IO쳣
	 */
	public static String getFullPathRelateClass(String relatedPath, Class cls) {
		String path = null;
		if (relatedPath == null) {
			throw new NullPointerException();
		}
		String clsPath = getPathFromClass(cls);
		File clsFile = new File(clsPath);
		String tempPath = clsFile.getParent() + File.separator + relatedPath;
		File file = new File(tempPath);
		try {
			path = file.getCanonicalPath();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return path;
	}

	/**
	 * ȡclassļλõURL
	 * 
	 * @param cls
	 * @return
	 */
	private static URL getClassLocationURL(final Class cls) {
		if (cls == null)
			throw new IllegalArgumentException("null input: cls");
		URL result = null;
		final String clsAsResource = cls.getName().replace('.', '/').concat(".class");
		final ProtectionDomain pd = cls.getProtectionDomain();
		if (pd != null) {
			final CodeSource cs = pd.getCodeSource();
			if (cs != null)
				result = cs.getLocation();
			if (result != null) {
				if ("file".equals(result.getProtocol())) {
					try {
						if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip"))
							result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(clsAsResource));
						else if (new File(result.getFile()).isDirectory())
							result = new URL(result, clsAsResource);
					} catch (MalformedURLException ignore) {
					}
				}
			}
		}
		if (result == null) {
			final ClassLoader clsLoader = cls.getClassLoader();
			result = clsLoader != null ? clsLoader.getResource(clsAsResource) : ClassLoader
					.getSystemResource(clsAsResource);
		}
		return result;
	}
}