package cn.base.util;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class ImportExcelUtil {
    private final static String excel2003L = ".xls";    //2003- 汾excel
    private final static String excel2007U = ".xlsx";   //2007+ 汾excel

    /**
     * ȡIOеݣװList<List<Object>>
     *
     * @param in,fileName
     * @return
     * @throws
     */
    public List<List<Object>> getBankListByExcel(InputStream in, String fileName) throws Exception {
        List<List<Object>> list = null;
        //Excel
        Workbook work = this.getWorkbook(in, fileName);
        if (null == work) {
            throw new Exception("ExcelΪգ");
        }
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;

        list = new ArrayList<List<Object>>();
        int blankColumn=1;        //ȡе
        //Excelеsheet
        for (int i = 0; i < work.getNumberOfSheets(); i++) {
            sheet = work.getSheetAt(i);
            if (sheet == null) {
                continue;
            }
            //ͷ
            row=sheet.getRow(0);
            int  maxcolumn=row.getLastCellNum();
            //ǰsheetе
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); j++) {
                row = sheet.getRow(j);   //е
                List<Object> li = new ArrayList<Object>();
                if (row == null) {
                    continue;
                }
                blankColumn=1;//ʼ
                for (int y = 0; y < maxcolumn; y++) {
                    cell = row.getCell(y);
                    if (null == cell) {
                        li.add("");
                        blankColumn++;
                    } else {
                        li.add(this.getCellValue(cell));
                    }
                }
                //жϿĿǷĿһ£һ¼list
                if (blankColumn < maxcolumn) {
                    list.add(li);
                }
            }
        }
        return list;
    }

    /**
     * ļ׺Ӧϴļİ汾
     *
     * @param inStr,fileName
     * @return
     * @throws Exception
     */
    public Workbook getWorkbook(InputStream inStr, String fileName) throws Exception {
        Workbook wb = null;
        String fileType = fileName.substring(fileName.lastIndexOf("."));
        if (excel2003L.equals(fileType)) {
            wb = new HSSFWorkbook(inStr);  //2003-
        } else if (excel2007U.equals(fileType)) {
            wb = new XSSFWorkbook(inStr);  //2007+
        } else {
            throw new Exception("ļʽ");
        }
        return wb;
    }

    /**
     * Աֵиʽ
     *
     * @param cell
     * @return
     */
    public Object getCellValue(Cell cell) {
        Object value = null;
        DecimalFormat df = new DecimalFormat("0");  //ʽnumber Stringַ
        SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd");  //ڸʽ
        DecimalFormat df2 = new DecimalFormat("0.00");  //ʽ

        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_STRING:
                value = cell.getRichStringCellValue().getString();
                break;
            case Cell.CELL_TYPE_NUMERIC:
                if ("General".equals(cell.getCellStyle().getDataFormatString())) {
                    value = String.valueOf(cell.getNumericCellValue());
                } else if ("m/d/yy".equals(cell.getCellStyle().getDataFormatString())) {
                    value = sdf.format(cell.getDateCellValue());
                } else {
                    value = df2.format(cell.getNumericCellValue());
                }
                break;
            case Cell.CELL_TYPE_BOOLEAN:
                value = cell.getBooleanCellValue();
                break;
            case Cell.CELL_TYPE_BLANK:
                value = "";
                break;
            default:
                break;
        }
        return value;
    }
}
