package cn.base.tinyftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FtpEasyDownload {
	public static Log logger = LogFactory.getLog(FtpEasyDownload.class);
	public static byte[] downLoadFile(String path) {
		BufferedInputStream bis = null;
		ByteArrayOutputStream bos = null;
		//InputStream is = null;
		try {
			if (path.toUpperCase().indexOf("FTP") != -1) {
				String tempUrl = path;
				tempUrl = tempUrl.replaceAll("\\\\", "/");
				URL url = new URL(tempUrl);
				URLConnection urlCon = url.openConnection();
				urlCon.setConnectTimeout(5000);
				urlCon.setReadTimeout(5000);
				urlCon.connect();
				bis = new BufferedInputStream(url.openStream());
				bos = new ByteArrayOutputStream();
				int buf_size = 1024;  
	            byte[] buffer = new byte[buf_size];  
	            int len = 0;  
	            while (-1 != (len = bis.read(buffer, 0, buf_size))) {  
	                bos.write(buffer, 0, len);  
	            }  
	            return bos.toByteArray();
			}
		} catch (Exception e) {
			logger.error("FTPͼƬ", e);
		} finally {
			try {
				if (bis != null) {
					bis.close();
				}
				if (bos != null) {
					bos.close();
				}
			} catch (IOException e) {
				logger.error("رFTPͨ", e);
			}
		}
		return null;
	}
	
	/**  
     * Զļ浽  
     * @param remoteFilePath Զļ·   
     * @param localFilePath ļ·  
     */
    public static void downloadFile(String remoteFilePath, String localFilePath)
    {
        URL urlfile = null;
        URLConnection ftpUrl = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        File f = new File(localFilePath);
        try
        {
            urlfile = new URL(remoteFilePath);
            ftpUrl = urlfile.openConnection();
            ftpUrl.setConnectTimeout(5000);
            ftpUrl.setReadTimeout(5000);
            ftpUrl.connect();
            bis = new BufferedInputStream(ftpUrl.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(f));
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1)
            {
                bos.write(b, 0, len);
            }
            bos.flush();
            bis.close();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        finally
        {
            try
            {
                bis.close();
                bos.close();
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }
        }
    }
   
	
	public static void main(String[] args) {
		try {
		//	String url="ftp://192.168.8.16/2015v/11/19/5555555555555555555551/94/28/0105879c-887f-4275-8b33-1e229b3aa73f.jpg";
			String url="ftp://192.168.8.16/2015v/11/19/5555555555555555555551/94/78/fdeb041d-db00-4952-91ee-e576c431bbad.jpg";
			byte[] tt=FtpEasyDownload.downLoadFile(url);
			String fileName = "D:/a/a.jpg";
			File file = new File(fileName);
			if(!file.getParentFile().exists()){
                file.getParentFile().mkdirs();
            }
			//file.createNewFile();
			System.out.println("====="+tt.length);
		    FileOutputStream out = new FileOutputStream(new File(fileName));
		    out.write(tt);   
		    out.flush();
		    out.close();   
		} catch (Exception e) {
			e.printStackTrace();
		}   
	}
}
