package cn.amq.business;
import java.net.InetAddress;
import java.net.UnknownHostException;

import org.apache.log4j.Logger;

import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import cn.amq.basis.AmqPublishBasisJob;
import cn.amq.peas.ModuleOnlineNotifyHolder;
import cn.amq.peas.ModuleOnlineNotifyPeas;
import cn.base.conf.ModuleConfFactory;
import cn.base.util.StringUtil;

import com.jtiny.msgthread.JtinyMsgThread;
import com.jtiny.utility.JtinyEvent;
/**
 * amq
 * @author ThinkPad
 *
 */
public class AmqPublishJob extends JtinyMsgThread{
	static Logger logger = Logger.getLogger(AmqPublishJob.class);
	AmqPublishBasisJob publishThread=null;
	private String amqServerUrl=null;
	
	public boolean isConnected(){
		return publishThread.isConnected();
	}
	
	public void setAmqServerUrl(String amqServerUrl){
		this.amqServerUrl=amqServerUrl;
	}
	
	public void start(){
		super.start();
		publishThread=new AmqPublishBasisJob(amqServerUrl);
		JtinyEvent msgEnityTimer=new JtinyEvent(AmqConst.AMQ_SETUP_INIT_EVENT,0,0,null,null,null);
		publishThread.putEvent(msgEnityTimer);
		publishThread.start();		
		//㱨״̬Ķʱ
		msgEnityTimer=new JtinyEvent(AmqConst.AMQ_MODULE_REPORT_TIMER,0,0,null,null,null);
		this.registerTimer(msgEnityTimer, 1000*60*1);
	}
	
	public AmqPublishJob(){

	}
	
	public void publishGeneralEvent(AmqBasisEvent amqBasisEvent,String subjectName){
		JtinyEvent publishMsg = new JtinyEvent(AmqConst.AMQ_PUBLISH_EVENT, 0, 0, subjectName, null, amqBasisEvent);
		publishThread.putEvent(publishMsg);
	}
	public void publishModuleReportMsg(String senderModuleName,String moduleType,String moduleId,String ip){
		 ModuleOnlineNotifyHolder message=new ModuleOnlineNotifyHolder();
		 message.setFsmkmc(senderModuleName);
		 ModuleOnlineNotifyPeas reportInfo=new ModuleOnlineNotifyPeas();
		 reportInfo.setGjxh(StringUtil.getUUID());
		 reportInfo.setMkbh(ModuleConfFactory.getInstance().getScatter().getModuleId());
		 reportInfo.setMkmc(moduleType);
		 reportInfo.setIp(ip);
		 reportInfo.setZt(AmqConst.AMQ_ONLINE); 
		 message.getList().add(reportInfo);
		 JtinyEvent publishMsg = new JtinyEvent(AmqConst.AMQ_PUBLISH_EVENT, 0, 0,AmqConst.AMQ_SUBJECT_moduleOnlineNotify, null, message);
		 publishThread.putEvent(publishMsg);
	}
	final public  void handleEvent(JtinyEvent msgEntity){
		switch(msgEntity.getMsgId()){
			case AmqConst.AMQ_MODULE_REPORT_TIMER:{
				logger.debug("*******************public module status***************************");
				JtinyEvent eventTimer=new JtinyEvent(AmqConst.AMQ_MODULE_REPORT_TIMER,0,0,null,null,null);
				this.registerTimer(eventTimer, 1000*40*1);
				String moduleId=ModuleConfFactory.getInstance().getScatter().getModuleId();
				this.publishModuleReportMsg(moduleId, moduleId, moduleId,getLocalIpAddress());
				break;
			}
			default:
				logger.warn("Task Received Unknow Message!");
				break;
		}
	}
	
	public static  String getLocalIpAddress(){
		String ip="127.0.0.1";
		try {
			ip = InetAddress.getLocalHost().getHostAddress();
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		return ip;
	}
	
}