package com.hzjt.service;

import com.hzjt.domain.Alarm;


public interface ImportService {

    /**
     * @Description: 清空redis中的部分旧数据
     * @Param: []
     * @Retrun: void
     */
    void cleanCache();

    /**
     * @Description: 将参数result中的部分数据存入redis中，并把格式校验成功的数据发布至对应频道中
     * @Param: [result]
     * @Retrun: void
     */
    void cacheAndPublish(String result);


    /**
     * @Description: 根据key值，返回redis中对应的结果
     * @Param: [key]
     * @Retrun: long
     */
    long getTempSize(String key);


}
