//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hzjt.controller;

import cn.hutool.json.JSONUtil;
import com.hzjt.domain.Alarm;
import com.hzjt.domain.AlarmEvents;
import com.hzjt.domain.Ftp;
import com.hzjt.domain.MediaList;
import com.hzjt.domain.ResponseEnum;
import com.hzjt.domain.Result;
import com.hzjt.domain.Sbtdspsr;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.handler.FileTransferManager;
import com.hzjt.handler.WebSocket;
import com.hzjt.mapper.SbtdspsrMapper;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.service.FtpService;
import com.hzjt.util.DateUtils;
import com.hzjt.util.JsonUtil;
import com.hzjt.util.StringEnum;
import com.hzjt.util.TraffAlarmRecordFromImgEnum;
import com.hzjt.util.TransHelper;
import com.hzjt.util.UUIDUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AlarmController {
    private static final Logger log = LoggerFactory.getLogger(TraffController.class);
    @Value("${alarmrecord.check.enable}")
    private String checkEnable;
    @Resource
    FtpService ftpService;
    @Resource
    private TraffAlarmRecordMapper traffAlarmRecordMapper;
    @Autowired
    WebSocket webSocket;
    @Resource
    SbtdspsrMapper sbtdspsrMapper;

    public AlarmController() {
    }

    @PostMapping({"/sendAlarmEvents"})
    public Result sendAlarmEvents(@RequestBody AlarmEvents alarmEvents) {
        log.info(JsonUtil.beanToString(alarmEvents));
        String sbbh = alarmEvents.getDeviceId();
        int tdbh = 0;
        List<Sbtdspsr> sbtdspsrs = this.sbtdspsrMapper.selectBySbbh(sbbh, Integer.valueOf(tdbh));
        if (sbtdspsrs.isEmpty()) {
            log.info("设备为:" + sbbh + ",通道为:" + tdbh + "未录入(备案)");
            return new Result(ResponseEnum.E_1002.getCode(), "设备为:" + sbbh + ",通道为:" + tdbh + "未录入(备案)", false);
        } else {
            String xzbh = ((Sbtdspsr)sbtdspsrs.get(0)).getXzbh();
            Alarm alarm = TransHelper.transAlarmResult(alarmEvents);
            alarm.setDept(xzbh);
            Result result = new Result();
            Traffalarmrecord traffAlarmRecord_init = new Traffalarmrecord();
            traffAlarmRecord_init.setAreaid(Long.valueOf(xzbh));
            traffAlarmRecord_init.setRecordtype(alarmEvents.getEventType().toLowerCase());
            if (alarmEvents.getStartTime() != null) {
                traffAlarmRecord_init.setRecordtime(DateUtils.getDateString(new Date(Long.valueOf(alarmEvents.getStartTime()) * 1000L)));
            }

            traffAlarmRecord_init.setFdid(alarmEvents.getDeviceId());
            traffAlarmRecord_init.setChannelid(0);
            traffAlarmRecord_init.setCreatetime(DateUtils.getDateString(new Date()));
            traffAlarmRecord_init.setObjlable(alarm.getObjLabel());
            traffAlarmRecord_init.setPushstatus(9);
            traffAlarmRecord_init.setProcessstatus("0");
            traffAlarmRecord_init.setManualstatus(1);
            traffAlarmRecord_init.setChannelname(alarmEvents.getDeviceName());
            traffAlarmRecord_init.setObjlable(alarmEvents.getObjectType());
            List<MediaList> imgBase64List = alarmEvents.getMediaList();
            String imgEnumHead = "IMG";
            int i = 0;
            Iterator var12 = imgBase64List.iterator();

            while(var12.hasNext()) {
                MediaList imgs = (MediaList)var12.next();
                if (imgs.getType().contains("jpg")) {
                    TraffAlarmRecordFromImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord_init, imgs.getSrc());
                    ++i;
                }

                if (imgs.getType().contains("mp4")) {
                    traffAlarmRecord_init.setVideourlfrom(imgs.getSrc());
                }
            }

            if (StringEnum.ONE.getValue().equals(this.checkEnable)) {
                traffAlarmRecord_init.setCheckstatus(9);
            }

            Map<Object, Object> map = new HashMap();
            map.put("type", "alarm");
            traffAlarmRecord_init.setEventid("66211" + UUIDUtils.createuuid());
            this.traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord_init);
            map.put("data", alarm);
            map.put("recordid", traffAlarmRecord_init.getRecordid());
            this.webSocket.GroupSending(JsonUtil.beanToString(map));

            try {
                Traffalarmrecord traffAlarmRecord = (Traffalarmrecord)JSONUtil.toBean(JsonUtil.beanToString(traffAlarmRecord_init), Traffalarmrecord.class);
                String basepath = traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
                Map<String, Object> transferRecordMap = new HashMap();
                FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
                Ftp ftp = this.ftpService.reloadFtp();
                FileTransferManager fileTransferManager = new FileTransferManager();
                fileTransferManager.transferFileIncludVideo(transferRecordMap, ftp, basepath, this.traffAlarmRecordMapper);
                traffAlarmRecord.setPushdesc("success");
                traffAlarmRecord.setPushstatus(0);
                this.traffAlarmRecordMapper.updatePushEvent(traffAlarmRecord);
                result.setSuccess(true);
            } catch (Exception var19) {
                result.setSuccess(false);
                log.error("alarmevent  error :{}", var19.toString());
            }

            return result;
        }
    }
}
