package com.hzjt.config;

import cn.hutool.json.JSONUtil;
import com.hzjt.domain.*;
import com.hzjt.handler.FileTransferManager;
import com.hzjt.handler.WebSocket;
import com.hzjt.mapper.SbtdspsrMapper;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.service.FtpService;
import com.hzjt.service.TraffFlowService;
import com.hzjt.service.TraffalarmrecordService;
import com.hzjt.util.DateUtils;
import com.hzjt.util.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

@Slf4j

@Configuration
@EnableScheduling
public class ScheduleTaskConfig {
    @Autowired
    TraffFlowService traffFlowService;

    @Autowired
    TraffalarmrecordService traffalarmrecordService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    FtpService ftpService;

    @Resource
    TraffAlarmRecordMapper traffAlarmRecordMapper;



    @Scheduled(cron = "0 0/50 * * * ?")//间隔50分钟
    private void statis() {
//        查询30分钟之前的所有没有上传成功的事件进行二次上传

        List<Traffalarmrecord> list = traffalarmrecordService.selectFailRecord();
        if(list.size()>0) {
            Ftp ftp = this.ftpService.reloadFtp();
            for (Traffalarmrecord traffAlarmRecord : list) {

                String basepath = traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
                Map<String, Object> transferRecordMap = new HashMap();
                FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
                FileTransferManager fileTransferManager = new FileTransferManager();
                try {
                    fileTransferManager.transferFile(transferRecordMap, ftp, basepath, this.traffAlarmRecordMapper);
                } catch (Exception e) {
                    log.error("alarmevent  error :{}", e.toString());
                }
                traffAlarmRecord.setPushdesc("success");
                traffAlarmRecord.setPushstatus(0);
                this.traffAlarmRecordMapper.updatePushEvent(traffAlarmRecord);
            }
        }

    }

    //    @Scheduled(cron = "0 */1 * * * ?")//每一个月执行一次
    private void reconnectWebsocket() {

        final Calendar c = Calendar.getInstance();
        if (c.get(Calendar.DATE) == c.getActualMaximum(Calendar.DATE)) {
//            log.info("每个月最后一天执行删除前2个月车流量数据操作start");
            //删除2个月之前车流量详情的数据
            traffFlowService.deleteBeforeTwoMonthVehicles();
        }
    }

//    @Scheduled(cron = "0 30/5 6-19 * * ?")//每隔5分钟统计当天目前为止的数据
//    private void statistoday() {
//        //判断是否为空表
//        //执行查询存在更新，不存在新增
//        log.info("每隔5分钟");
//       Integer result= traffFlowService.insertOrUpdatevehicleTodaystatistic();
//        log.info("today"+result);
//
//    }

}
