package com.hzjt.handler;

import cn.hutool.json.JSONUtil;
import com.hzjt.domain.Ftp;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.domain.TransferResult;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.util.DateUtils;
import com.hzjt.util.FTPUtil;
import com.hzjt.util.JsonUtil;
import com.hzjt.util.ThreadPoolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

public class FileTransferManager {
    private static final Logger log = LoggerFactory.getLogger(FileTransferManager.class);

    private static CompletionService<TransferResult> completionService = new ExecutorCompletionService<TransferResult>(ThreadPoolUtil.getPool());

    static ScheduledExecutorService schedulepool = Executors.newScheduledThreadPool(5);



    /**
     * @param transferRecord
     * @param ftp
     * @param basePath
     * @return
     * @throws Exception
     */
    public List<TransferResult> transferFile(final Map<String, Object> transferRecord, final Ftp ftp, final String basePath,TraffAlarmRecordMapper traffAlarmRecordMapper ) throws Exception {
        Long recordid = Long.parseLong(transferRecord.get("recordid").toString());
        int count = 0;
        Iterator var5 = transferRecord.keySet().iterator();
        while (true) {
            String key;
            do {
                if (!var5.hasNext()) {
                    List<TransferResult> listret = new ArrayList();

                    for (int i = 0; i < count; ++i) {
                        listret.add(completionService.poll(4L, TimeUnit.SECONDS).get());
                    }

                    return listret;
                }

                key = (String) var5.next();
            } while (!key.equals("img1path") && !key.equals("img2path") && !key.equals("img3path") && !key.equals("img4path") && !key.equals("img5path") && !key.equals("videopath"));

            String url = transferRecord.get(key).toString();
            ++count;
            String finalKey = key;
            completionService.submit(() -> {
                log.info("recordid:{}", recordid);
                TransferResult result = new TransferResult(recordid, finalKey, url, "", false);
                String pname = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_0000_" + finalKey.replace("path", "");
                String filesuff = "videopath".equals(finalKey) ? ".mp4" : ".jpg";
                String fileName = pname + filesuff;
                String ftputl = basePath + "/" + fileName;
                if ("videopath".equals(finalKey)) {
                    result.setUrlfrom(url);
                    result.setImgpath(ftputl);
                    result.setFilename(fileName);
                    schedulepool.schedule(() -> {
                        Traffalarmrecord record = new Traffalarmrecord();
                        try {
                            record.setRecordid(result.getRecordid());
                            HttpURLConnection connection = (HttpURLConnection) (new URL(result.getUrlfrom())).openConnection();
                            connection.setReadTimeout(2000);
                            connection.setConnectTimeout(3000);
                            connection.setRequestMethod("GET");
                            log.info("video record:{} upload fail:", JsonUtil.beanToString(result));
                            if (connection.getResponseCode() == 200) {
                                InputStream inputStream = connection.getInputStream();
//                                if (result.getImgpath().indexOf("/") > -1) {
                                boolean r = FTPUtil.uploadFile(ftp, "gstraff/" + basePath, result.getFilename(), inputStream);
                                if (r) {
                                    record.setVideopath(result.getImgpath());
                                    log.info("video:{} upload success:", result.getImgpath());
                                } else {
                                    log.info("video:{} upload fail:", result.getUrlfrom());
                                    record.setVideopath("");
                                }
//                                }
                            } else {
                                log.info("video:{} upload fail:", url);
                                record.setVideopath("");
                            }
                        } catch (IOException var11) {
                            log.info("video:{} error:{}",result.getUrlfrom(),var11.toString());
                            record.setVideopath("");
                            return 0;
                        } finally {

                            traffAlarmRecordMapper.updateTraffAlarmRecordUrl(record);
                        }
                        return 1;

                    }, 50L, TimeUnit.SECONDS);

                } else {
                    try {

                        HttpURLConnection connection = (HttpURLConnection) (new URL(url)).openConnection();
                        connection.setReadTimeout(2000);
                        connection.setConnectTimeout(3000);
                        connection.setRequestMethod("GET");
                        if (connection.getResponseCode() == 200) {
                            InputStream inputStream = connection.getInputStream();
                            boolean r = FTPUtil.uploadFile(ftp, "gstraff/" + basePath, fileName, inputStream);
                            result.setResult(r);
                            if (r) {
                                result.setImgpath(ftputl);
                                log.info("imgpath or  videopath success:{}", ftputl);
                            } else {
                                log.info("imgpath or  videopath fail:{}", ftputl);
                            }
                        } else {
                            log.error("imgpath or  videopath connection  error code:{}", connection.getResponseCode() + " ," + result.toString());
                        }
                    } catch (IOException var13) {
                        log.error("imgpath or  videopath error:{}", var13.toString());
                    }
                }

                return result;
            });
        }

    }


    public static void fetchUrlsFromRecord(Traffalarmrecord record, Map<String, Object> transferRecord) {
        if (record == null || record.getRecordid() == null) {
            return;
        }

        transferRecord.put("recordid", record.getRecordid());

        if (record.getImg1path() == null && record.getImg1urlfrom() != null) {
            transferRecord.put("img1path", record.getImg1urlfrom());
        }

        if (record.getImg2path() == null && record.getImg2urlfrom() != null) {
            transferRecord.put("img2path", record.getImg2urlfrom());
        }

        if (record.getImg3path() == null && record.getImg3urlfrom() != null) {
            transferRecord.put("img3path", record.getImg3urlfrom());
        }

        if (record.getImg4path() == null && record.getImg4urlfrom() != null) {
            transferRecord.put("img4path", record.getImg4urlfrom());
        }

        if (record.getImg5path() == null && record.getImg5urlfrom() != null) {
            transferRecord.put("img5path", record.getImg5urlfrom());
        }

        if (record.getVideopath() == null && record.getVideourlfrom() != null) {
            transferRecord.put("videopath", record.getVideourlfrom());
        }
    }

    public static List<TransferResult> transferFileIncludVideo(Map<String, Object> transferRecord, Ftp ftp, String basePath) throws Exception {
        Long recordid = Long.parseLong(transferRecord.get("recordid").toString());
        int count = 0;
        Iterator var5 = transferRecord.keySet().iterator();

        while (true) {
            String key;
            do {
                if (!var5.hasNext()) {
                    List<TransferResult> listret = new ArrayList();

                    for (int i = 0; i < count; ++i) {
                        listret.add(completionService.poll(10L, TimeUnit.SECONDS).get());
                    }
                    return listret;
                }

                key = (String) var5.next();
            } while (!key.equals("img1path") && !key.equals("img2path") && !key.equals("img3path") && !key.equals("img4path") && !key.equals("img5path") && !key.equals("videopath"));

            String url = transferRecord.get(key).toString();
            ++count;
            String finalKey = key;
            completionService.submit(() -> {
                TransferResult result = new TransferResult(recordid, finalKey, url, "", false);

                try {
                    String filesuff = "videopath".equals(finalKey) ? ".mp4" : ".jpg";
                    HttpURLConnection connection = (HttpURLConnection) (new URL(url)).openConnection();
                    connection.setReadTimeout(2000);
                    connection.setConnectTimeout(3000);
                    connection.setRequestMethod("GET");
                    if (connection.getResponseCode() == 200) {
                        InputStream inputStream = connection.getInputStream();
                        String pname = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_0000_" + finalKey.replace("path", "");
                        String fileName = pname + filesuff;
                        String ftputl = basePath + "/" + fileName;
                        boolean r = FTPUtil.uploadFile(ftp, "gstraff/" + basePath, fileName, inputStream);
                        result.setResult(r);
                        if (r) {
                            result.setImgpath(ftputl);
                        }
                    } else {
                        log.error("imgpath or  videopath connection  error code:{}", connection.getResponseCode() + " ," + result.toString());
                    }
                } catch (IOException var13) {
                    log.error("imgpath or  videopath error:{}", var13.toString());
                }

                return result;
            });
        }
    }
    public void traffAlarmRecordUrlUpdate(List<TransferResult> results,TraffAlarmRecordMapper traffAlarmRecordMapper) throws Exception {
//        List<TransferResult> results = JSONUtil.toList(JSONUtil.parseArray(JSONUtil.toJsonStr(resultslist)), TransferResult.class);
        for (TransferResult result : results) {
            log.info("results={}", JSONUtil.toJsonStr(result));
            Traffalarmrecord record = new Traffalarmrecord();
            record.setRecordid(result.getRecordid());
            if (result.getResult()) {
                switch (result.getPathvalue()) {
                    case "img1path":
                        record.setImg1path(result.getImgpath());
                        break;
                    case "img2path":
                        record.setImg2path(result.getImgpath());
                        break;
                    case "img3path":
                        record.setImg3path(result.getImgpath());
                        break;
                    case "img4path":
                        record.setImg4path(result.getImgpath());
                        break;
                    case "img5path":
                        record.setImg5path(result.getImgpath());
                        break;
                    case "videopath":
                        record.setVideopath(result.getImgpath());
                        break;
                    case "urlfrom":
                        record.setVideourlfrom(result.getUrlfrom());
                        break;
                    default:
//                        log.info("unknow pathvalue"+ result.getPathvalue());
                        break;
                }
//                更新数据
                traffAlarmRecordMapper.updateTraffAlarmRecordUrl(record);

            }
        }
    }



}

