package com.hzjt.service;

import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class FLVCacheService {
    private static final Logger log = LoggerFactory.getLogger(FLVCacheService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Value("${flv.resisvalue}")
    private String resisvalue;


    @Value("${flv.url}")
    private String url;

    public void getvalue(String videoid,String rtsp) {
        try {
            HttpHeaders headers = new HttpHeaders();
            RestTemplate client = new RestTemplate();
            String jsonString = "{\"video_id\":\""+videoid+"\",\"url\":\""+rtsp+"\"}";
//            log.info("jsonString"+jsonString);
            headers.setContentType(MediaType.valueOf("application/json;UTF-8"));
            HttpEntity<String> strEntity = new HttpEntity<>(jsonString,headers);
            ResponseEntity<String> response = client.postForEntity(url, strEntity, String.class);
            //解析返回结果
//            log.info("response"+response.getBody());
            if (response.getBody() != null) {
//                log.info("flv response success" );
                stringRedisTemplate.opsForValue().set(videoid,response.getBody(), 10, TimeUnit.MINUTES);
            } else {
                log.error("flv response " + "empty...");
            }
        } catch (Exception e) {
            System.out.println(e.toString());
            log.error(e.getMessage());
        }
    }



    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return headers;
    }

}
