/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CCharAccessor
extends CharAccessor {
    T4CMAREngine mare;
    boolean underlyingLong = false;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CCharAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
        this.calculateSizeTmpByteArray();
    }

    T4CCharAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, int n10, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n9;
        this.definedColumnSize = n10;
        this.calculateSizeTmpByteArray();
        this.oacmxl = n8;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int n2 = this.indicatorIndex + this.lastRowProcessed;
        int n3 = this.lengthIndex + this.lastRowProcessed;
        byte[] byArray = this.statement.tmpByteArray;
        int n4 = this.columnIndex + this.lastRowProcessed * this.charLength;
        if (this.rowSpaceIndicator == null) {
            byte[] byArray2 = new byte[16000];
            this.mare.unmarshalCLR(byArray2, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        if (this.statement.maxFieldSize > 0) {
            this.mare.unmarshalCLR(byArray, 0, this.meta, this.statement.maxFieldSize);
        } else {
            this.mare.unmarshalCLR(byArray, 0, this.meta);
        }
        this.tmp[0] = this.meta[0];
        int n5 = 0;
        n5 = this.formOfUse == 2 ? this.statement.connection.conversion.NCHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n4 + 1, this.tmp, this.charLength - 1) : this.statement.connection.conversion.CHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n4 + 1, this.tmp, this.charLength - 1);
        this.rowSpaceChar[n4] = (char)(n5 * 2);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
        } else {
            this.rowSpaceIndicator[n3] = (short)(this.meta[0] * 2);
            this.rowSpaceIndicator[n2] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int n3 = this.columnIndex + this.lastRowProcessed * this.charLength;
        int n4 = this.columnIndex + n2 * this.charLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2;
        short s2 = this.rowSpaceIndicator[n8];
        int n9 = this.metaDataIndex + this.lastRowProcessed * 1;
        int n10 = this.metaDataIndex + n2 * 1;
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceChar, n4, this.rowSpaceChar, n3, this.rowSpaceChar[n4] / 2 + 1);
        }
        System.arraycopy(this.rowSpaceMetaData, n10, this.rowSpaceMetaData, n9, 1);
        ++this.lastRowProcessed;
    }

    @Override
    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.charLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.charLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(cArray, n5, this.rowSpaceChar, n4, cArray[n5] / 2 + 1);
        }
    }

    @Override
    void calculateSizeTmpByteArray() {
        int n2 = this.formOfUse == 2 ? (this.charLength - 1) * this.statement.connection.conversion.maxNCharSize : (this.charLength - 1) * this.statement.connection.conversion.cMaxCharSize;
        if (this.statement.sizeTmpByteArray < n2) {
            this.statement.sizeTmpByteArray = n2;
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    @Override
    NUMBER getNUMBER(int n2) throws SQLException {
        NUMBER nUMBER = null;
        if (this.definedColumnType == 0) {
            nUMBER = super.getNUMBER(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                return T4CVarcharAccessor.StringToNUMBER(string);
            }
        }
        return nUMBER;
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        if (this.definedColumnType == 0) {
            dATE = super.getDATE(n2);
        } else {
            Date date = this.getDate(n2);
            if (date != null) {
                dATE = new DATE(date);
            }
        }
        return dATE;
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.definedColumnType == 0) {
            tIMESTAMP = super.getTIMESTAMP(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMP = new TIMESTAMP(timestamp);
            }
        }
        return tIMESTAMP;
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPTZ = super.getTIMESTAMPTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPTZ;
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPLTZ = super.getTIMESTAMPLTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPLTZ;
    }

    @Override
    RAW getRAW(int n2) throws SQLException {
        RAW rAW = null;
        if (this.definedColumnType == 0) {
            rAW = super.getRAW(n2);
        } else {
            if (this.rowSpaceIndicator == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
                rAW = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars(n2)) : new RAW(super.getBytes(n2));
            }
        }
        return rAW;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(n2);
        }
        Datum datum = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(n2);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(n2);
                }
                case 91: {
                    return this.getDATE(n2);
                }
                case 92: {
                    return this.getDATE(n2);
                }
                case 93: {
                    return this.getTIMESTAMP(n2);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(n2);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(n2);
                }
                case -8: {
                    return this.getROWID(n2);
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return datum;
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getBytes(n2);
        }
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.shareBytes();
        }
        return null;
    }

    @Override
    boolean getBoolean(int n2) throws SQLException {
        boolean bl = false;
        bl = this.definedColumnType == 0 ? super.getBoolean(n2) : this.getNUMBER(n2).booleanValue();
        return bl;
    }

    @Override
    byte getByte(int n2) throws SQLException {
        byte by = 0;
        by = this.definedColumnType == 0 ? super.getByte(n2) : this.getNUMBER(n2).byteValue();
        return by;
    }

    @Override
    int getInt(int n2) throws SQLException {
        int n3 = 0;
        n3 = this.definedColumnType == 0 ? super.getInt(n2) : this.getNUMBER(n2).intValue();
        return n3;
    }

    @Override
    short getShort(int n2) throws SQLException {
        short s2 = 0;
        s2 = this.definedColumnType == 0 ? super.getShort(n2) : this.getNUMBER(n2).shortValue();
        return s2;
    }

    @Override
    long getLong(int n2) throws SQLException {
        long l2 = 0L;
        l2 = this.definedColumnType == 0 ? super.getLong(n2) : this.getNUMBER(n2).longValue();
        return l2;
    }

    @Override
    float getFloat(int n2) throws SQLException {
        float f2 = 0.0f;
        f2 = this.definedColumnType == 0 ? super.getFloat(n2) : this.getNUMBER(n2).floatValue();
        return f2;
    }

    @Override
    double getDouble(int n2) throws SQLException {
        double d2 = 0.0;
        d2 = this.definedColumnType == 0 ? super.getDouble(n2) : this.getNUMBER(n2).doubleValue();
        return d2;
    }

    @Override
    Date getDate(int n2) throws SQLException {
        Date date = null;
        if (this.definedColumnType == 0) {
            date = super.getDate(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                date = new Date(T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nArray).getTimeInMillis());
            }
        }
        return date;
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        if (this.definedColumnType == 0) {
            timestamp = super.getTimestamp(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
            }
        }
        return timestamp;
    }

    @Override
    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.definedColumnType == 0) {
            time = super.getTime(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                time = new Time(calendar.getTimeInMillis());
            }
        }
        return time;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n2);
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(n2);
                }
                case 4: {
                    return this.getInt(n2);
                }
                case -6: {
                    return this.getByte(n2);
                }
                case 5: {
                    return this.getShort(n2);
                }
                case -7: 
                case 16: {
                    return this.getBoolean(n2);
                }
                case -5: {
                    return this.getLong(n2);
                }
                case 7: {
                    return Float.valueOf(this.getFloat(n2));
                }
                case 6: 
                case 8: {
                    return this.getDouble(n2);
                }
                case 91: {
                    return this.getDate(n2);
                }
                case 92: {
                    return this.getTime(n2);
                }
                case 93: {
                    return this.getTimestamp(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytesFromHexChars(n2);
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return var2_2;
    }
}

