//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hzjt.controller;

import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.RateLimiter;
import com.hzjt.domain.Alarm;
import com.hzjt.domain.Ftp;
import com.hzjt.domain.MqttAlarm;
import com.hzjt.domain.ResponseEnum;
import com.hzjt.domain.ResultObj;
import com.hzjt.domain.Sbtdspsr;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.handler.FileTransferManager;
import com.hzjt.handler.WebSocket;
import com.hzjt.mapper.SbtdspsrMapper;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.redis.RedisDao;
import com.hzjt.service.EventWriteService;
import com.hzjt.service.FLVCacheService;
import com.hzjt.service.FtpService;
import com.hzjt.service.TraffFlowService;
import com.hzjt.util.DateUtils;
import com.hzjt.util.FTPUtil;
import com.hzjt.util.JsonUtil;
import com.hzjt.util.StringEnum;
import com.hzjt.util.TraffAlarmRecordFromImgEnum;
import com.hzjt.util.TraffAlarmRecordImgEnum;
import com.hzjt.util.UUIDUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sun.net.www.protocol.ftp.FtpURLConnection;

@RestController
public class TraffController {
    private static final Logger log = LoggerFactory.getLogger(TraffController.class);
    @Autowired
    WebSocket webSocket;
    private Map<String, RateLimiter> rateLimiterMap;
    private String port;
    private String dept;
    private Integer rate = 10;
    private SbtdspsrMapper sbtdspsrMapper;
    @Autowired
    TraffFlowService traffFlowService;
    @Value("${json.resisurl}")
    private String resisjsonvalue;
    @Value("${ftppath}")
    private String ftppath;
    @Value("${ftpServiceUrl}")
    private String ftpServiceUrl;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    RedisDao redisDao;
    @Resource
    TraffAlarmRecordMapper traffAlarmRecordMapper;
    @Autowired
    FtpService ftpService;
    @Autowired
    EventWriteService eventWriteService;
    @Value("ftpIp")
    String ftpIp;
    @Value("ftpPort")
    private String ftpPort;
    @Value("ftpUsername")
    private String ftpUsername;
    @Value("ftpPassword")
    private String ftpPassword;
    @Value("${alarmrecord.check.enable}")
    private String checkEnable;
    Long ldir = new Long(180L);
    @Autowired
    FLVCacheService flvCacheService;
    Long eightHour = 25200000L;
    String manualStatus = "0";
    private static final String TYPE = "TRAFFIC_INCIDENT_ALARM";

    @Autowired
    public TraffController(@Value("${port}") String port, @Value("${message.dept}") String dept, @Value("${message.rate}") Integer rate, SbtdspsrMapper sbtdspsrMapper) {
        this.port = port;
        this.rate = rate;
        this.dept = dept.substring(0, 5);
        this.sbtdspsrMapper = sbtdspsrMapper;
        this.rateLimiterMap = new ConcurrentHashMap(16);
    }

    @PostMapping({"/alarmevent"})
    public ResultObj rece(@RequestBody Alarm trffClientMessage) {
        if (!"TRAFFIC_INCIDENT_ALARM".equals(trffClientMessage.getType())) {
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "type类型不正确");
        } else if (trffClientMessage.getImg_urls().isEmpty()) {
            return ResultObj.error(ResponseEnum.E_1004.getCode(), "img_urls值不能为空");
        } else if (StringUtils.isBlank(trffClientMessage.getIncident_type())) {
            log.info("incident_type值不能为空" + trffClientMessage.toString());
            return ResultObj.error(ResponseEnum.E_1004.getCode(), "incident_type值不能为空");
        } else {
            Long current = (new Date()).getTime() - Long.valueOf(trffClientMessage.getTs());
            if (current >= this.eightHour) {
                Long lontime = Long.valueOf(trffClientMessage.getTs()) + 28800000L;
                trffClientMessage.setTs(String.valueOf(lontime));
            }

            String videoId = trffClientMessage.getVideo_id();
            if (StringUtils.isBlank(videoId)) {
                log.info("video_id值异常 值为:" + videoId);
                return ResultObj.error(ResponseEnum.E_1002.getCode(), "video_id值异常 值为:" + videoId);
            } else {
                int tdbh = 0;
                List<Sbtdspsr> sbtdspsrs = this.sbtdspsrMapper.selectBySbbh(videoId, Integer.valueOf(tdbh));
                if (sbtdspsrs.isEmpty()) {
                    log.info("设备为:" + videoId + ",通道为:" + tdbh + "未录入(备案)");
                    return ResultObj.error(ResponseEnum.E_1002.getCode(), "设备为:" + videoId + ",通道为:" + tdbh + "未录入(备案)");
                } else {
                    String xzbh = ((Sbtdspsr)sbtdspsrs.get(0)).getXzbh();
                    if (xzbh.length() != 12) {
                        log.info("设备为:" + videoId + ",通道为:" + tdbh + "配置的行政区划" + xzbh + "不合规");
                        return ResultObj.error(ResponseEnum.E_1002.getCode(), "设备为:" + videoId + ",通道为:" + tdbh + "配置的行政区划不合规");
                    } else {
                        trffClientMessage.setDept(xzbh);

                        try {
                            this.sendevent(trffClientMessage, (Sbtdspsr)sbtdspsrs.get(0));
                        } catch (Exception var8) {
                            log.error("MessageController receive putData error：{}", var8.toString());
                        }

                        return ResultObj.ok(trffClientMessage);
                    }
                }
            }
        }
    }

    public void sendevent(Alarm trffClientMessage, Sbtdspsr spr) {
        Traffalarmrecord traffAlarmRecord_init = new Traffalarmrecord();
        traffAlarmRecord_init.setAreaid(Long.valueOf(trffClientMessage.getDept()));
        traffAlarmRecord_init.setRecordtype(trffClientMessage.getIncident_type().toLowerCase());
        traffAlarmRecord_init.setRecordtime(DateUtils.getDateString(new Date(Long.valueOf(trffClientMessage.getTs()))));
        traffAlarmRecord_init.setFdid(trffClientMessage.getVideo_id());
        traffAlarmRecord_init.setChannelid(0);
        traffAlarmRecord_init.setVideourlfrom(trffClientMessage.getVideo_record_url());
        traffAlarmRecord_init.setCreatetime(DateUtils.getDateString(new Date()));
        traffAlarmRecord_init.setObjlable(trffClientMessage.getObjLabel());
        traffAlarmRecord_init.setPushstatus(9);
        traffAlarmRecord_init.setProcessstatus("0");
        traffAlarmRecord_init.setManualstatus(1);
        traffAlarmRecord_init.setChannelname(spr.getTdmc());
        List<String> imgBase64List = trffClientMessage.getImg_base64();
        String imgEnumHead = "IMG";
        Ftp ftp = this.ftpService.reloadFtp();

        String basepath;
        for(int i = 0; i < imgBase64List.size(); ++i) {
            String path = trffClientMessage.getVideo_id() + (traffAlarmRecord_init.getChannelid() < 10 ? "0" + traffAlarmRecord_init.getChannelid() : traffAlarmRecord_init.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            basepath = UUIDUtils.createuuid() + ".jpg";
            if (FTPUtil.uploadFile(ftp, "gstraff/" + path, basepath, (String)imgBase64List.get(i))) {
                TraffAlarmRecordImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord_init, path + "/" + basepath);
            }
        }

        List<String> imgUrls = trffClientMessage.getImg_urls();

        for(int j = 0; j < imgUrls.size(); ++j) {
            TraffAlarmRecordFromImgEnum.valueOf(imgEnumHead + j).setImg(traffAlarmRecord_init, (String)imgUrls.get(j));
        }

        if (StringEnum.ONE.getValue().equals(this.checkEnable)) {
            traffAlarmRecord_init.setCheckstatus(9);
        }

        Map<Object, Object> map = new HashMap();
        map.put("type", "alarm");
        traffAlarmRecord_init.setEventid("66211" + UUIDUtils.createuuid());
        this.traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord_init);
        map.put("data", trffClientMessage);
        map.put("recordid", traffAlarmRecord_init.getRecordid());
        this.webSocket.GroupSending(JsonUtil.beanToString(map));

        try {
            Traffalarmrecord traffAlarmRecord = (Traffalarmrecord)JSONUtil.toBean(JsonUtil.beanToString(traffAlarmRecord_init), Traffalarmrecord.class);
            basepath = traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            Map<String, Object> transferRecordMap = new HashMap();
            FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
            FileTransferManager fileTransferManager = new FileTransferManager();
            fileTransferManager.transferFile(transferRecordMap, ftp, basepath, this.traffAlarmRecordMapper);
            traffAlarmRecord.setPushdesc("success");
            traffAlarmRecord.setPushstatus(0);
            this.traffAlarmRecordMapper.updatePushEvent(traffAlarmRecord);
        } catch (Exception var13) {
            log.error("alarmevent  error :{}", var13.toString());
        }

    }

    private void sendtomqtt(Alarm trffClientMessage, String wbbh, Traffalarmrecord traffAlarmRecord) {
        log.info("sendtomqtt");
        if (null != wbbh && !"".equals(wbbh)) {
            MqttAlarm mqttalarm = new MqttAlarm();
            String mqttbh = this.traffAlarmRecordMapper.seletmqttbh(trffClientMessage.getIncident_type());
            mqttalarm.setAlarmTime(traffAlarmRecord.getRecordtime());
            mqttalarm.setCompanyId("66211");
            mqttalarm.setImagePath(traffAlarmRecord.getImg1path() == null ? "" : this.ftpServiceUrl + "?location=" + traffAlarmRecord.getImg1path().replace("ftp://" + this.ftppath + "/", ""));
            mqttalarm.setVideoPath(traffAlarmRecord.getVideopath() == null ? "" : this.ftpServiceUrl + "?location=" + traffAlarmRecord.getVideopath().replace("ftp://" + this.ftppath + "/", ""));
            mqttalarm.setDeviceId(wbbh);
            log.info("mqtt data1：{}", JsonUtil.beanToString(mqttalarm));
            if (null != trffClientMessage.getObj_location()) {
                mqttalarm.setX(trffClientMessage.getObj_location().get("x") == null ? null : ((BigDecimal)trffClientMessage.getObj_location().get("x")).toString());
                mqttalarm.setY(trffClientMessage.getObj_location().get("y") == null ? null : ((BigDecimal)trffClientMessage.getObj_location().get("y")).toString());
                mqttalarm.setWidth(trffClientMessage.getObj_location().get("width") == null ? null : ((BigDecimal)trffClientMessage.getObj_location().get("width")).toString());
                mqttalarm.setHeight(trffClientMessage.getObj_location().get("height") == null ? null : ((BigDecimal)trffClientMessage.getObj_location().get("height")).toString());
            }

            mqttalarm.setEventTypeId(mqttbh);
            log.info("mqtt data：{}", JsonUtil.beanToString(mqttalarm));
        } else {
            log.info("设备为:{}wbbh is empty", traffAlarmRecord.getFdid());
        }

    }

    private RateLimiter getRateLimiter(String videoId) {
        RateLimiter rateLimiter;
        if (this.rateLimiterMap.containsKey(videoId)) {
            rateLimiter = (RateLimiter)this.rateLimiterMap.get(videoId);
        } else {
            RateLimiter value = RateLimiter.create((double)this.rate);
            rateLimiter = (RateLimiter)this.rateLimiterMap.putIfAbsent(videoId, value);
            if (rateLimiter == null) {
                rateLimiter = value;
            }
        }

        return rateLimiter;
    }

    @GetMapping({"/getflv/{videoid}"})
    public String getflv(@PathVariable("videoid") String videoid) {
        String rtsp = this.traffFlowService.selectSbtddspsrRtspByVideoid(videoid);
        if (null != rtsp) {
            if (null == this.stringRedisTemplate.opsForValue().get(videoid)) {
                this.flvCacheService.getvalue(videoid, rtsp);
            }

            JSONObject jsonObject = JSONObject.parseObject((String)this.stringRedisTemplate.opsForValue().get(videoid));
            if (null != jsonObject.getJSONArray("play_list") && jsonObject.getJSONArray("play_list").size() > 0) {
                return String.valueOf(jsonObject.getJSONArray("play_list").get(0));
            }
        }

        return "";
    }

    @GetMapping({"/sendtouser/{recordid}"})
    @ResponseBody
    public Integer sendtouser(@PathVariable("recordid") String recordid) {
        Traffalarmrecord traffalarmrecord = (Traffalarmrecord)this.traffAlarmRecordMapper.selectByPrimaryKey(recordid);
        if (traffalarmrecord == null) {
            return 0;
        } else {
            Alarm alarm = new Alarm();
            new Base64Encoder();
            alarm.setTs(Long.toString(traffalarmrecord.getRecordtime() == null ? (new Date()).getTime() : DateUtils.Parsedate(traffalarmrecord.getRecordtime()).getTime()));
            alarm.setDept(traffalarmrecord.getAreaid() == null ? null : Long.toString(traffalarmrecord.getAreaid()));
            alarm.setVideo_id(traffalarmrecord.getFdid() + "_" + traffalarmrecord.getChannelid());
            alarm.setIncident_type(traffalarmrecord.getRecordtype());
            List<String> strImgs = new ArrayList();
            byte[] Img;
            if (traffalarmrecord.getImg1path() != null) {
                Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg1path());
                strImgs.add(Img != null ? Base64Encoder.encode(Img) : null);
            }

            if (traffalarmrecord.getImg2path() != null) {
                Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg2path());
                strImgs.add(Img != null ? Base64Encoder.encode(Img) : null);
            }

            if (traffalarmrecord.getImg3path() != null) {
                Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg3path());
                strImgs.add(Img != null ? Base64Encoder.encode(Img) : null);
            }

            if (traffalarmrecord.getImg4path() != null) {
                Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg4path());
                strImgs.add(Img != null ? Base64Encoder.encode(Img) : null);
            }

            if (traffalarmrecord.getImg5path() != null) {
                Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg5path());
                strImgs.add(Img != null ? Base64Encoder.encode(Img) : null);
            }

            alarm.setImg_base64(strImgs);
            Map<Object, Object> map = new HashMap();
            map.put("type", "alarm");
            map.put("data", alarm);
            map.put("recordid", recordid);
            this.webSocket.GroupSending(JsonUtil.beanToString(map));

            try {
                ResultObj obj = this.eventWriteService.updateAndAutoSendEvent(traffalarmrecord);
                log.info("send to guangda novideopath --->response message" + obj.toString());
                return obj.getStatus() == 200 ? 1 : 0;
            } catch (Exception var8) {
                log.info("send to guangda novideopath --->response error" + var8.toString());
                return 1;
            }
        }
    }

    @GetMapping({"/test"})
    @ResponseBody
    public void test() {
        String manualStatus = this.traffAlarmRecordMapper.seletManualStatus();
        Alarm alarm = new Alarm();
        alarm.setVideo_id("33_65_230_156_554_fbXdTkVe98u_ecvs_0");
        alarm.setIncident_type("NO_MOTOR_BAN");
        String str = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB1UlEQVRIS5WVjTEEQRBG30WACBABGSACLgJEgAicCBABIkAEiIAMkAERUG9remtua2Z3rquuam935nvTPf0zY9y2gENgH/B5Ny3/AL6AV+A5PReVZhV9xS6Bk/RdEUVzE7qXXtwDVyVQCaDoNeC3m/T7qRxkHThPvz9gnrzqlw8Bi3RyTyyoJjzkCTJcO8ApoEed5QAF74CHLDRDofwOShA9PgYOwpMAGPN34A04Grl3T6kZ/5KFJ5vAthEIgC4pLGgsLFMAoWp8pktfCFh6MZG2LQAlPLDpvS3ALDBrNhoutRUQh54LcJNhGYt9ONYKcH1XiAJ80CVTdMpWATwB6wIsEKswALpnupZsLE1dfwsorKl3WAP0hTKgCDcFTeeSWQc5YF+APcaXLSGKSq/1sBzah6h7GCmefNMqgP6SV0nTVsBSmq5SaK2A6AxdFi1V3kSxtQDMNPtal5l5s/Oy7SF2wlo/EmBIvbOS+f4ldQVBfbNzsR3Sj7p3UYG4yZBGKuaQELeLqtVNwGG6xUzwo9PJTGgxwY/p5HpYHDghJN0TrqVxaXXWQAqfpQH1nfrZ0uyuFUw+awUJcGNsVjjC9Ts2u6cqMgowhpH/IwGE2fxK99GH9R91mncY+HKoHAAAAABJRU5ErkJggg==";
        List<String> arrlist = new ArrayList();
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        alarm.setImg_base64(arrlist);
        alarm.setTs("1345677777");
        alarm.setType("TRAFFIC_INCIDENT_ALARM");
        Map<Object, Object> map = new HashMap();
        map.put("type", "alarm");
        map.put("data", alarm);
        map.put("recordid", "33448");
        this.webSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord = new Traffalarmrecord();
        traffAlarmRecord.setRecordid(Long.parseLong("33448"));
        traffAlarmRecord.setChannelid(new Integer(1));
        traffAlarmRecord.setFdid("20200305112042989");
        traffAlarmRecord.setRecordtype("NO_MOTOR_BAN");
        map.put("recordid", "33449");
        this.webSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord2 = new Traffalarmrecord();
        traffAlarmRecord2.setRecordid(Long.parseLong("33449"));
        traffAlarmRecord2.setChannelid(new Integer(1));
        traffAlarmRecord2.setFdid("20200305112042989");
        traffAlarmRecord2.setRecordtype("WRONG_DIRECTION");
    }

    @GetMapping({"/api/alg/files"})
    protected void fielagent(@RequestParam("location") String location, HttpServletRequest request, HttpServletResponse response) {
        long startTime = System.currentTimeMillis();
        String ftpPath = "ftp://" + this.ftppath + "/" + location;
        FileInputStream hFile = null;
        OutputStream toClient = null;
        InputStream inputStream = null;
        BufferedInputStream bis = null;

        try {
            response.reset();
            response.setHeader("Expires", "Sat, 10 May 2059 12:00:00 GMT");
            response.setHeader("Cache-Control", "max-age=315360000");
            if (StringUtils.isNotBlank(ftpPath)) {
                String mp4file;
                if (!ftpPath.endsWith(".jpg") && !ftpPath.endsWith(".JPG") && !ftpPath.endsWith(".png") && !ftpPath.endsWith(".PNG") && !ftpPath.endsWith(".gif") && !ftpPath.endsWith(".GIF")) {
                    if (ftpPath.endsWith(".mp4") || ftpPath.endsWith(".MP4")) {
                        response.setContentType("video/mpeg4; charset=utf-8");
                        mp4file = ftpPath.substring(ftpPath.lastIndexOf("/") + 1);
                        response.setHeader("Content-Disposition", "attachment;fileName=" + mp4file);
                    }
                } else {
                    response.setContentType("image/" + ftpPath.substring(ftpPath.lastIndexOf(".") + 1) + "; charset=utf-8");
                }

                mp4file = new String(ftpPath.getBytes("ISO8859-1"), "GBK");
                String[] arr = mp4file.split(";");
                FtpURLConnection ftpUrl = null;
                HttpURLConnection httpUrl = null;

                for(int i = 0; i < arr.length; ++i) {
                    try {
                        URL url = new URL(arr[i]);
                        if (arr[i].toUpperCase().indexOf("FTP") != -1) {
                            ftpUrl = (FtpURLConnection)url.openConnection();
                            ftpUrl.setConnectTimeout(30000);
                            ftpUrl.setReadTimeout(30000);
                            bis = new BufferedInputStream(ftpUrl.getInputStream());
                            response.setContentLength(ftpUrl.getContentLength());
                        } else {
                            httpUrl = (HttpURLConnection)url.openConnection();
                            httpUrl.setConnectTimeout(30000);
                            httpUrl.setReadTimeout(30000);
                            bis = new BufferedInputStream(httpUrl.getInputStream());
                            response.setContentLength(httpUrl.getContentLength());
                        }

                        ServletOutputStream servletOutputStream = response.getOutputStream();
                        IOUtils.copy(bis, servletOutputStream);
                        if (bis != null) {
                            bis.close();
                        }

                        if (httpUrl != null) {
                            httpUrl.disconnect();
                        }

                        if (ftpUrl != null) {
                            ftpUrl.close();
                        }

                        if (servletOutputStream != null) {
                            servletOutputStream.close();
                        }
                    } catch (Exception var28) {
                        response.setContentType("text/html;charset=GBK");
                        response.setCharacterEncoding("GBK");
                        PrintWriter out = response.getWriter();
                        out.write("无法打开图片!");
                        out.flush();
                        log.info("ftpagent error " + ftpUrl + var28.toString());
                    } finally {
                        if (bis != null) {
                            bis.close();
                        }

                        if (httpUrl != null) {
                            httpUrl.disconnect();
                        }

                        if (ftpUrl != null) {
                            ftpUrl.close();
                        }

                        if (toClient != null) {
                            ((OutputStream)toClient).close();
                        }

                    }
                }

                return;
            }
        } catch (Exception var30) {
        } finally {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly((Closeable)toClient);
            IOUtils.closeQuietly((Closeable)hFile);
            IOUtils.closeQuietly((Closeable)inputStream);
        }

    }
}
