//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hzjt.handler;

import cn.hutool.json.JSONUtil;
import com.hzjt.domain.Ftp;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.domain.TransferResult;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.util.DateUtils;
import com.hzjt.util.FTPUtil;
import com.hzjt.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferManager {
    private static final Logger log = LoggerFactory.getLogger(FileTransferManager.class);
    private static CompletionService<TransferResult> completionService = new ExecutorCompletionService(ThreadPoolUtil.getPool());
    static ScheduledExecutorService schedulepool = Executors.newScheduledThreadPool(10);
    private static ExecutorService executorService = Executors.newCachedThreadPool();

    public FileTransferManager() {
    }

    public void transferFile(Map<String, Object> transferRecord, Ftp ftp, String basePath, TraffAlarmRecordMapper traffAlarmRecordMapper) throws Exception {
        executorService.execute(() -> {
            Long recordid = Long.parseLong(transferRecord.get("recordid").toString());
            Iterator var5 = transferRecord.keySet().iterator();
            while(var5.hasNext()) {
                String finalKey = (String)var5.next();
                log.info("finalKey :{}", finalKey);
                String url = transferRecord.get(finalKey).toString();
                log.info("recordid:{}", recordid);
                String pname = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_0000_" + finalKey.replace("path", "");
                String filesuff = "videopath".equals(finalKey) ? ".mp4" : ".jpg";
                String fileName = pname + filesuff;
                String ftputl = basePath + "/" + fileName;
                if ("videopath".equals(finalKey)) {
                    schedulepool.schedule(() -> {
                        Traffalarmrecord record = new Traffalarmrecord();
                        Integer var9;
                        try {
                            record.setRecordid(recordid);
                            HttpURLConnection connection = (HttpURLConnection)(new URL(url)).openConnection();
                            connection.setReadTimeout(2000);
                            connection.setConnectTimeout(3000);
                            connection.setRequestMethod("GET");
                            if (connection.getResponseCode() == 200) {
                                InputStream inputStream = connection.getInputStream();
                                boolean r = FTPUtil.uploadFile(ftp, "gstraff/" + basePath, fileName, inputStream);
                                if (r) {
                                    record.setVideopath(ftputl);
                                    record.setVideourlfrom(url);
                                    log.info("video:{} upload success:", ftputl);
                                } else {
                                    log.info("video:{} upload fail:", ftputl);
                                    record.setVideopath("");
                                }

                                return 1;
                            } else {
                                log.info("video:{} upload fail:", url);
                                record.setVideopath("");
                                return 1;
                            }
                        } catch (IOException var14) {
                            log.info("video:{} error:{}", url, var14.toString());
                            record.setVideopath("");
                            var9 = 0;
                        } finally {
                            traffAlarmRecordMapper.updateTraffAlarmRecordUrl(record);
                        }

                        return var9;
                    }, 1L, TimeUnit.SECONDS);
                } else {
                    try {
                        HttpURLConnection connection = (HttpURLConnection)(new URL(url)).openConnection();
                        connection.setReadTimeout(2000);
                        connection.setConnectTimeout(3000);
                        connection.setRequestMethod("GET");
                        if (connection.getResponseCode() == 200) {
                            InputStream inputStream = connection.getInputStream();
                            boolean r = FTPUtil.uploadFile(ftp, "gstraff/" + basePath, fileName, inputStream);
                            if (r) {
                                log.info("imgpath or  videopath success:{}", ftputl);
                                Traffalarmrecord record = new Traffalarmrecord();
                                record.setRecordid(recordid);
                                this.updateTraffAlarmRecordUrl(finalKey, record, ftputl, traffAlarmRecordMapper);
                            } else {
                                log.info("imgpath or  videopath fail:{}", ftputl);
                            }
                        } else {
                            log.error("imgpath or  videopath connection  error code:{}", connection.getResponseCode());
                        }
                    } catch (Exception var17) {
                        log.error("imgpath or  videopath error:{}", var17.toString());
                    }
                }
            }

        });
    }

    public static void fetchUrlsFromRecord(Traffalarmrecord record, Map<String, Object> transferRecord) {
        if (record != null && record.getRecordid() != null) {
            transferRecord.put("recordid", record.getRecordid());
            if (record.getImg1path() == null && record.getImg1urlfrom() != null) {
                transferRecord.put("img1path", record.getImg1urlfrom());
            }

            if (record.getImg2path() == null && record.getImg2urlfrom() != null) {
                transferRecord.put("img2path", record.getImg2urlfrom());
            }

            if (record.getImg3path() == null && record.getImg3urlfrom() != null) {
                transferRecord.put("img3path", record.getImg3urlfrom());
            }

            if (record.getImg4path() == null && record.getImg4urlfrom() != null) {
                transferRecord.put("img4path", record.getImg4urlfrom());
            }

            if (record.getImg5path() == null && record.getImg5urlfrom() != null) {
                transferRecord.put("img5path", record.getImg5urlfrom());
            }

            if (record.getVideopath() == null && record.getVideourlfrom() != null) {
                transferRecord.put("videopath", record.getVideourlfrom());
            }

        }
    }

    public void transferFileIncludVideo(Map<String, Object> transferRecord, Ftp ftp, String basePath, TraffAlarmRecordMapper traffAlarmRecordMapper) throws Exception {
        executorService.execute(() -> {
            Long recordid = Long.parseLong(transferRecord.get("recordid").toString());
            Iterator var5 = transferRecord.keySet().iterator();

            while(var5.hasNext()) {
                String finalKey = (String)var5.next();
                log.info("finalKey :{}", finalKey);
                String url = transferRecord.get(finalKey).toString();
                try {
                    String filesuff = "videopath".equals(finalKey) ? ".mp4" : ".jpg";
                    HttpURLConnection connection = (HttpURLConnection)(new URL(url)).openConnection();
                    connection.setReadTimeout(2000);
                    connection.setConnectTimeout(3000);
                    connection.setRequestMethod("GET");
                    if (connection.getResponseCode() == 200) {
                        InputStream inputStream = connection.getInputStream();
                        String pname = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_0000_" + finalKey.replace("path", "");
                        String fileName = pname + filesuff;
                        String ftputl = basePath + "/" + fileName;
                        boolean r = FTPUtil.uploadFile(ftp, "gstraff/" + basePath, fileName, inputStream);
                        if (r) {
                            Traffalarmrecord record = new Traffalarmrecord();
                            record.setRecordid(recordid);
                            this.updateTraffAlarmRecordUrl(finalKey, record, ftputl, traffAlarmRecordMapper);
                        }
                    } else {
                        log.error("imgpath or  videopath connection  error code:{}", connection.getResponseCode());
                    }
                } catch (Exception var17) {
                    log.error("imgpath or  videopath error:{}", var17.toString());
                }
            }

        });
    }

    public void traffAlarmRecordUrlUpdate(List<TransferResult> results, TraffAlarmRecordMapper traffAlarmRecordMapper) throws Exception {
        Iterator var3 = results.iterator();

        while(var3.hasNext()) {
            TransferResult result = (TransferResult)var3.next();
            log.info("results={}", JSONUtil.toJsonStr(result));
            Traffalarmrecord record = new Traffalarmrecord();
            record.setRecordid(result.getRecordid());
            if (result.getResult()) {
                String pathvalue = result.getPathvalue();
                switch (pathvalue){
                case "img1path":
                    record.setImg1path(pathvalue);
                    break;
                case "img2path":
                    record.setImg2path(pathvalue);
                    break;
                case "img3path":
                    record.setImg3path(pathvalue);
                    break;
                case "img4path":
                    record.setImg4path(pathvalue);
                    break;
                case "img5path":
                    record.setImg5path(pathvalue);
                    break;
                case "videopath":
                    record.setVideopath(pathvalue);
                    break;
                case "urlfrom":
                    record.setVideourlfrom(result.getUrlfrom());
                    break;
                default:
//                        log.info("unknow pathvalue"+ result.getPathvalue());
                    break;
            }
//                更新数据
            traffAlarmRecordMapper.updateTraffAlarmRecordUrl(record);
            }
        }

    }

    public void updateTraffAlarmRecordUrl(String key, Traffalarmrecord record, String path, TraffAlarmRecordMapper traffAlarmRecordMapper) throws Exception {
       switch(key) {
            case "img1path":
                record.setImg1path(path);
                break;
            case "img2path":
                record.setImg2path(path);
                break;
            case "img3path":
                record.setImg3path(path);
                break;
            case "img4path":
                record.setImg4path(path);
                break;
            case "img5path":
                record.setImg5path(path);
                break;
            case "videopath":
                record.setVideopath(path);
                break;
            case "urlfrom":
                record.setVideourlfrom(path);
        }

        traffAlarmRecordMapper.updateTraffAlarmRecordUrl(record);
    }
}
