//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hzjt.redis;

import com.hzjt.domain.Alarm;
import com.hzjt.domain.Ftp;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.handler.FileTransferManager;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.service.EventWriteService;
import com.hzjt.service.FtpService;
import com.hzjt.util.DateUtils;
import com.hzjt.util.FTPUtil;
import com.hzjt.util.JsonUtil;
import com.hzjt.util.StringEnum;
import com.hzjt.util.TraffAlarmRecordFromImgEnum;
import com.hzjt.util.TraffAlarmRecordImgEnum;
import com.hzjt.util.UUIDUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class Receiver {
    @Autowired
    RedisDao redisDao;
    @Autowired
    private TraffAlarmRecordMapper traffAlarmRecordMapper;
    @Autowired
    FtpService ftpService;
    @Autowired
    EventWriteService eventWriteService;
    ScheduledExecutorService schedulepool = Executors.newScheduledThreadPool(5);
    @Value("ftpIp")
    String ftpIp;
    @Value("ftpPort")
    private String ftpPort;
    @Value("ftpUsername")
    private String ftpUsername;
    @Value("ftpPassword")
    private String ftpPassword;
    @Value("${alarmrecord.check.enable}")
    private String checkEnable;
    private static final Logger log = LoggerFactory.getLogger(Receiver.class);

    public Receiver() {
    }

    public void receiveSingle(String Message) throws InterruptedException {
        Alarm trffClientMessage = (Alarm)JsonUtil.stringToBean(Message, Alarm.class);
        List<String> imgBase64List = trffClientMessage.getImg_base64();
        Traffalarmrecord traffAlarmRecord = new Traffalarmrecord();
        String imgEnumHead = "IMG";
        Ftp ftp = this.ftpService.reloadFtp();

        String fdid;
        for(int i = 0; i < imgBase64List.size(); ++i) {
            String path = trffClientMessage.getVideo_id() + "/" + DateUtils.formatCurrDayNoSign();
            fdid = UUIDUtils.createuuid() + ".jpg";
            if (FTPUtil.uploadFile(ftp, path, fdid, (String)imgBase64List.get(i))) {
                TraffAlarmRecordImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, FTPUtil.getFtpUrl(ftp) + path + "/" + fdid);
            }
        }

        List<String> imgUrls = trffClientMessage.getImg_urls();

        for(int i = 0; i < imgUrls.size(); ++i) {
            TraffAlarmRecordFromImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, (String)imgUrls.get(i));
        }

        String[] videoIdArr = trffClientMessage.getVideo_id().split("_");
        fdid = videoIdArr[0];
        traffAlarmRecord.setFdid(fdid);
        Integer channelid = Integer.valueOf(videoIdArr[1]) + 1;
        traffAlarmRecord.setChannelid(channelid);
        if (StringEnum.ONE.getValue().equals(this.checkEnable)) {
            traffAlarmRecord.setCheckstatus(9);
        }

        traffAlarmRecord.setProcessstatus("0");
        traffAlarmRecord.setAreaid(Long.valueOf(trffClientMessage.getDept()));
        traffAlarmRecord.setRecordtype(trffClientMessage.getIncident_type().toLowerCase());
        traffAlarmRecord.setVideourlfrom(trffClientMessage.getVideo_record_url());
        traffAlarmRecord.setRecordtime(DateUtils.getDateString(new Date(Long.valueOf(trffClientMessage.getTs()))));
        traffAlarmRecord.setCreatetime(DateUtils.getDateString(new Date()));
        traffAlarmRecord.setObjlable(trffClientMessage.getObjLabel());
        traffAlarmRecord.setPushstatus(9);
        this.traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord);

        try {
            String basepath = "gstraff/" + traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            Map<String, Object> transferRecordMap = new HashMap();
            FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
            new FileTransferManager();
        } catch (Exception var14) {
            log.error("解析事件告警数据异常 :" + var14.getMessage());
        }

        this.redisDao.incrOrDecr("excelToDB:succSizeTempKey", -1L);
    }

    public void receiveList(String message) throws InterruptedException {
    }
}
