package com.hzjt.service;

import cn.hutool.json.JSONUtil;
import com.hzjt.domain.*;
import com.hzjt.mapper.SbtdspsrMapper;
import com.hzjt.mapper.TraffdevicewriteresultMapper;
import com.hzjt.util.ThreadPoolUtil;
import com.hzjt.util.TransHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

@Service
@Slf4j
public class TraffdevicewriteresultService {

    @Autowired
    private RestTemplate restTemplate;
    @Value("${qingzhi.devicewrite.url}")
    private String url;
    @Value("${qingzhi.devicewrite.timeout}")
    private Integer timeout;

    @Autowired
    private TraffdevicewriteresultMapper traffdevicewriteresultMapper;

    @Autowired
    SbtdspsrMapper sbtdspsrMapper;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Value("${qingzhi.devicewritesupplier.name}")
    String devicesupplier;

    @Value("${qingzhi.redis.token}")
    String qztoken;

    @Value("${qingzhi.devicewrite.url}")
    String devicewriteurl;


    private static CompletionService<ResultObj> threadService  = new ExecutorCompletionService<ResultObj>(ThreadPoolUtil.getPool());
    public ResultObj update(SbtdspsrParam sbtdspsr) {
        DeviceWriteParam param = TransHelper.transDevice(sbtdspsr, CodeConst.device_update);
        WriteResultObj writeResultObj = new WriteResultObj(); //deviceWritePost(param);
        if (writeResultObj.getStatus() == 200) {
            return ResultObj.ok(writeResultObj.getMessage());
        }
        return ResultObj.error(writeResultObj.getStatus(), writeResultObj.getMessage());
    }

    public ResultObj remove(SbtdspsrParam sbtdspsr) {
        DeviceWriteParam param = TransHelper.transDevice(sbtdspsr, CodeConst.device_remove);
        WriteResultObj writeResultObj = new WriteResultObj(); //deviceWritePost(param);
        if (writeResultObj.getStatus() == 200) {
            return ResultObj.ok(writeResultObj.getMessage());
        }
        return ResultObj.error(writeResultObj.getStatus(), writeResultObj.getMessage());
    }

    public ResultObj report(SbtdspsrParam sbtdspsr) {
        DeviceWriteParam param = TransHelper.transDevice(sbtdspsr, CodeConst.device_report);
        WriteResultObj writeResultObj = new WriteResultObj(); //deviceWritePost(param);
        if (writeResultObj.getStatus() == 200) {
            return ResultObj.ok(writeResultObj.getMessage());
        }
        return ResultObj.error(writeResultObj.getStatus(), writeResultObj.getMessage());
    }

    private void write(HttpServletResponse response, String content) throws IOException {
        response.getWriter().write(content + "<br/>");
        response.flushBuffer();
        response.getWriter().flush();
    }

}