/**
  * Copyright 2021 json.cn 
  */
package com.cx.cn.cxquartz.vo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.util.List;

public class VoiceResultObj {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    /**
     * 响应业务状态
     * 200	成功
     * 201	错误
     * 400	参数错误
     */
    private Integer Code;

    /**
     * 响应消息
     */
    private String msg;

    /**
     * 响应中的数据
     */
    private Object data;
    private String page;

    public static VoiceResultObj error(Integer status, String msg, Object data) {
        return new VoiceResultObj(status, msg, data);
    }

    public static VoiceResultObj ok(Object data) {
        return new VoiceResultObj(data);
    }

    public static VoiceResultObj ok() {
        return ok(null);
    }

    private VoiceResultObj() {

    }

    public static VoiceResultObj error(Integer status, String msg) {

        return new VoiceResultObj(status, msg, null);
    }

    private VoiceResultObj(Integer code, String msg, Object data) {
        this.Code = code;
        this.msg = msg;
        this.data = data;
    }

    private VoiceResultObj(Object data) {
        this.Code =1;
        this.msg = "success";
        this.data = data;
    }

    public Integer getCode() {
        return Code;
    }

    public void setCode(Integer code) {
        this.Code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    /**
     * 将json结果集转化为SysResult对象
     *
     * @param jsonData json数据
     * @param clazz SysResult中的object类型
     * @return SysResult对象
     */
    public static VoiceResultObj formatToPojo(String jsonData, Class<?> clazz) {
        try {
            if (clazz == null) {
                return MAPPER.readValue(jsonData, VoiceResultObj.class);
            }
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (data.isObject()) {
                obj = MAPPER.readValue(data.traverse(), clazz);
            } else if (data.isTextual()) {
                obj = MAPPER.readValue(data.asText(), clazz);
            }
            return error( Integer.parseInt(jsonNode.get("code").toString()), jsonNode.get("msg").asText(), obj);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 没有object对象的转化
     *
     * @param json 字符串
     * @return SysResult对象
     */
    public static VoiceResultObj format(String json) {
        try {
            return MAPPER.readValue(json, VoiceResultObj.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Object是集合转化
     *
     * @param jsonData json数据
     * @param clazz 集合中的类型
     * @return SysResult对象
     */
    public static VoiceResultObj formatToList(String jsonData, Class<?> clazz) {
        try {
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (data.isArray() && data.size() > 0) {
                obj = MAPPER.readValue(data.traverse(),
                        MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
            }
            return error(Integer.parseInt(jsonNode.get("code").toString()), jsonNode.get("msg").asText(), obj);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        return "ResultObj{" +
                "code=" + Code +
                ", msg='" + msg + '\'' +
                ", obj=" + data +
                '}';
    }


}