package com.cx.cn.cxquartz.util;

import com.cx.cn.cxquartz.controller.ExtController;
import com.cx.cn.cxquartz.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;

public class FileTransferManager {
    private static CompletionService<String> completionService = new ExecutorCompletionService<String>(ThreadPoolUtil.getPool());
    private static CompletionService<String> threadService = new ExecutorCompletionService<String>(ThreadPoolUtil.getPool());
    private static final Logger log = LoggerFactory.getLogger(ExtController.class);

    /**
     * @param ftp
     * @param basePath
     * @return
     * @throws Exception
     */
    public static void transferFile(final TraffAlarmRecord traffAlarmRecord, final Ftp ftp, final String basePath) throws Exception {
        final Long recordid = traffAlarmRecord.getRecordid();
        String fileName = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_img1.jpg";
        String ftputl = FTPUtil.getFtpUrl(ftp) + basePath + "/" + fileName;
        traffAlarmRecord.setImg1path(ftputl);
        completionService.submit(() -> {
                    try {
                        HttpURLConnection connection = (HttpURLConnection) new URL(traffAlarmRecord.getImg1urlfrom()).openConnection();
                        connection.setReadTimeout(2000);    //延迟连接
                        connection.setConnectTimeout(3000);
                        connection.setRequestMethod("GET");
                        if (connection.getResponseCode() == HttpURLConnection.HTTP_OK || connection.getResponseCode() == HttpURLConnection.HTTP_NOT_MODIFIED) {
                            InputStream inputStream = connection.getInputStream();
                            boolean r = FTPUtil.uploadFile(ftp, basePath, fileName, inputStream);
                            if (r) {
                                log.info(" ftpupload  success:{}", ftputl);
                            }
                        } else {
                            log.error("connection code: " + connection.getResponseCode());
                        }
                    } catch (IOException e) {
                        log.error("ftputl connection error:{}", e.toString());
                        return "0";
                    }
                    return "1";
                }
        );
    }

    public static void fetchUrlsFromRecord(TraffAlarmRecord record, Map<String, Object> transferRecord) {
        if (record == null || record.getRecordid() == null) {
            return;
        }
        transferRecord.put("recordid", record.getRecordid());

        if (record.getImg1path() == null && record.getImg1urlfrom() != null) {
            transferRecord.put("img1path", record.getImg1urlfrom());
        }
    }

    public static TraffAlarmRecord traffAlarmRecordUrlUpdate(List<TransferResult> results) throws Exception {
        TraffAlarmRecord record = new TraffAlarmRecord();
        for (TransferResult result : results) {
            record.setRecordid(result.getRecordid());
            if (result.getResult()) {
                switch (result.getPathvalue()) {
                    case "img1path":
                        record.setImg1path(result.getImgpath());
                        break;
                    case "videopath":
                        record.setVideopath(result.getImgpath());
                        break;
                    default:
                        break;
                }
            }
        }
        return record;
    }

    public static GoalStructureParam getGoalStructureParam(Long[] roiarray, int model, BASE64Encoder base64Encoder, TraffAlarmRecord transferRecord) {
        //获得图片进行分析
        GoalStructureParam param = new GoalStructureParam();
        param.setOutput(new Output(1));
        param.setModel(model);
        param.setApiout("1");////打开1400标准输出，默认可以不填
        List<ImageList> list = new ArrayList<>();
        getImageList("1", roiarray, base64Encoder, list, transferRecord.getImg1path());
        param.setImageList(list);
        return param;

    }


    private static void getImageList(String id, Long[] roiarray, BASE64Encoder base64Encoder, List<ImageList> list, String img1path) {
        if (null != img1path && !"".equals(img1path)) {

            byte[] Img = FTPUtil.getFtpPicBytes(img1path);
            if (Img != null) {
                list.add(new ImageList(id, roiarray, 10, 1, 20, 100, base64Encoder.encode(Img).replaceAll("\r|\n", "")));

            }
        }
    }


    public static String urlTransToFtp(String url, final Ftp ftp, final String basePath) {

        threadService.submit(() -> {
            try {
                HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
                connection.setReadTimeout(2000);    //延迟连接
                connection.setConnectTimeout(3000);
                connection.setRequestMethod("GET");
                if (connection.getResponseCode() == HttpURLConnection.HTTP_OK || connection.getResponseCode() == HttpURLConnection.HTTP_NOT_MODIFIED) {
                    InputStream inputStream = connection.getInputStream();
                    String pname = DateUtils.formatCurrDayNoSign() + ".jpg";
                    String ftputl = FTPUtil.getFtpUrl(ftp) + basePath + pname;
                    boolean r = FTPUtil.uploadFile(ftp, basePath, pname, inputStream);
                    if (r) {
                        return ftputl;
                    }
                } else {
                    log.error("connection code: " + connection.getResponseCode());
                }
            } catch (IOException e) {
                System.out.println(e.toString());
                log.error(e.toString());
            }
            return url;
        });
        try {
            return threadService.poll(10, TimeUnit.SECONDS).get();
        } catch (Exception ex) {
            return url;
        }
    }

}

