package com.cx.cn.cxquartz.config;

import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.util.RestUtil;
import com.cx.cn.cxquartz.vo.Sbtdspsr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.Calendar;
import java.util.List;


@Configuration
@EnableScheduling
public class ScheduleTaskConfig {

    @Autowired
    private SbtdspsrService sbtdspsrService;
    @Value("${file.getrtspbyurl}")
    private String getrtspbyurl;
    RestUtil restUtil=new RestUtil();
    /***
     * 每隔20分钟执行一遍判断rtsp 是否变换
     */
    @Scheduled(cron = "0 0 2 * * ? ")
    private void statis() {
        //查询所有监控设备，更新rtsp 地址
        List<Sbtdspsr> sbtdpsrList= sbtdspsrService.list();
        //调用decice 端口获得新的rtsp 地址，如果与表里的一样无需更新，不一样则立即更新
        for(Sbtdspsr  sbtd:sbtdpsrList)
        {
            restUtil.rtspChangeVlue(sbtd.getSbbh(),sbtd.getSqurllj(),getrtspbyurl);
        }
    }


//    @Scheduled(cron = "0 30/5 6-19 * * ?")//每隔5分钟统计当天目前为止的数据
//    private void statistoday() {
//        //判断是否为空表
//        //执行查询存在更新，不存在新增
//        log.info("每隔5分钟");
//       Integer result= traffFlowService.insertOrUpdatevehicleTodaystatistic();
//        log.info("today"+result);
//
//    }

}
