package com.cx.cn.cxquartz.util;

import com.alibaba.fastjson.JSONObject;
import com.cx.cn.cxquartz.controller.ExtController;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestUtil {

    private static final Logger logger = LoggerFactory.getLogger(RestUtil.class);
    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    SbtdspsrService sbtdspsrService;

    public String getnewRtspVlue(String devicecode,String getrtspbyurl ){
        String rtspnewvalue="";
        Map<String, String> map = new HashMap<>();
        map.put("deviceCode", devicecode);
        ResponseEntity<String> responseEntity = restTemplate.getForEntity(getrtspbyurl+"?deviceCode={deviceCode}", String.class, map);
        JSONObject json = JSONObject.parseObject(responseEntity.getBody());
        if (null != json.getString("errorCode") && json.getString("errorCode").equals("0")) {
            //返回rtsp  地址
            json = JSONObject.parseObject(json.getString("data"));
            if (null != json.get("rtspUri") && !"".equals(json.get("rtspUri"))) {
                rtspnewvalue = String.valueOf(json.get("rtspUri"));
                if(rtspnewvalue.contains("rtsp")) {
                    //更新sbtdspsr  地址
                    int result = sbtdspsrService.updateRecogByRtsp(rtspnewvalue, devicecode);
                    if (result > 0) {
                        logger.info("更新rtsp success");
                    } else {
                        logger.info("设备" + devicecode + "不存在");
                    }
                }
                else {
                    logger.info("获取失败");
                }
            }
        }
        return rtspnewvalue;
    }
    public void rtspChangeVlue(String devicecode,String oldrtsp,String getrtspbyurl ){
        String rtspnewvalue="";
        Map<String, String> map = new HashMap<>();
        map.put("deviceCode", devicecode);
        ResponseEntity<String> responseEntity = restTemplate.getForEntity(getrtspbyurl+"?deviceCode={deviceCode}", String.class, map);
        JSONObject json = JSONObject.parseObject(responseEntity.getBody());
        if (null != json.getString("errorCode") && json.getString("errorCode").equals("0")) {
            //返回rtsp  地址
            json = JSONObject.parseObject(json.getString("data"));
            if (null != json.get("rtspUri") && !"".equals(json.get("rtspUri"))) {
                rtspnewvalue = String.valueOf(json.get("rtspUri"));
                //与新获得的rtsp 比较，如果一样则不更新，否则更新
                if(oldrtsp.contains("rtsp") && !oldrtsp.equals(rtspnewvalue)) {
                    //更新sbtdspsr  地址
                    int result = sbtdspsrService.updateRecogByRtsp(rtspnewvalue, devicecode);
                    if (result > 0) {
                        logger.info("更新rtsp success");
                    } else {
                        logger.info("设备" + devicecode + "不存在");
                    }
                }
                else {
                    logger.info("获取失败");
                }
            }
        }
    }

    public  void getPicture(List<String> imgUrls, Map<String, Object> maps, HttpEntity<String> formEntity,String rtspurl) {
        ResponseEntity<String> exchange = restTemplate.exchange(rtspurl + "?url={rtspvalue}&refresh={refresh}",
                HttpMethod.GET, formEntity, String.class, maps);
        if(null!=exchange.getBody()) {
            JSONObject json = JSONObject.parseObject(exchange.getBody());
            if (null != json.getString("ret") && json.getString("ret").equals("0")) {
                //获得图片地址
                imgUrls.add(json.getString("url"));
            }
        }
    }
}
