package com.cx.cn.cxquartz.job;

import com.cx.cn.cxquartz.config.QueueConstants;
import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.redis.QueueSender;
import com.cx.cn.cxquartz.util.ApplicationContextHolder;
import org.quartz.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.Date;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

@DisallowConcurrentExecution
public class QuartzMainJobFactory implements Job {

    private static Logger logger = LoggerFactory.getLogger(QuartzMainJobFactory.class);

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
//        logger.info(new Date().toLocaleString());
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        RabbitTemplate rabbitTemplate = (RabbitTemplate) ApplicationContextHolder.getBean("rabbitTemplate");
        try {
            //根据事件类型进行redis通道分配
//            qeueSender.sendMsg("taskinfo", jobDataMap.get("taskinfo"));
            //根据事件类型进行rabbitmq分配
            CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
            rabbitTemplate.convertAndSend(QueueConstants.QueueSnapTaskEnum.QUEUE_SNAP_TASK_ENUM.getExchange(),
                    QueueConstants.QueueSnapTaskEnum.QUEUE_SNAP_TASK_ENUM.getRouteKey(),
                    MessageHelper.objToMsg(jobDataMap.get("taskinfo")),
                    correlationData);




        }catch (Exception  ex){
            logger.error("Scheduler executing error:{}",ex);
        }

    }
}
