package com.cx.cn.cxquartz.config;

/**
 * 消息队列常量
 */
public class QueueConstants {

    /**
     * 派发任务队列常量
     */
    public interface QueueSnapTaskConsumer{
        /**
         * 交换机名称
         */
        String EXCHANGE = "RabbitMQ.DirectExchange.SnapTaskConsumer";
        /**
         * 队列名称
         */
        String QUEUE = "RabbitMQ.DirectQueue.SnapTaskConsumer";
        /**
         * 路由键
         */
        String ROUTEKEY = "RabbitMQ.RouteKey.SnapTaskConsumer";
    }

    /**
     * 消息通知队列
     */
    public enum QueueSnapTaskEnum {
        QUEUE_SNAP_TASK_ENUM(QueueConstants.QueueSnapTaskConsumer.EXCHANGE,
                QueueConstants.QueueSnapTaskConsumer.QUEUE,
                QueueConstants.QueueSnapTaskConsumer.ROUTEKEY);
        /**
         * 交换机名称
         */
        private String exchange;
        /**
         * 队列名称
         */
        private String queue;
        /**
         * 路由键
         */
        private String routeKey;

        QueueSnapTaskEnum(String exchange, String queue, String routeKey) {
            this.exchange = exchange;
            this.queue = queue;
            this.routeKey = routeKey;
        }

        public String getExchange() {
            return exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getQueue() {
            return queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getRouteKey() {
            return routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }
    }

}
