package com.cx.cn.cxquartz.controller;


import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.service.quartz.QuartzService;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/ai")
public class QuartzController {

    private static final Logger logger = LoggerFactory.getLogger(QuartzController.class);

    @Autowired
    private QuartzService quartzService;





    @Autowired
    private RestTemplate restTemplate;

//    @Autowired
//    FtpService ftpService;
//
//    @RequestMapping(value = "/add/taskpage", method = RequestMethod.GET)
//    public String addTaskpage() {
//        return "addtask";
//    }
//
//    @ResponseBody
//    @RequestMapping(value = "/add/task", method = RequestMethod.POST)
//    public String addTask(QuartzTaskInformations taskInformations) {
//        try {
//            taskInformations.setSchedulerrule("*/" + taskInformations.getSchedulerrule() + " * * * * ?");
//            String result = quartzService.addTask(taskInformations);
//            return result;
//        } catch (Exception e) {
//            logger.error("/add/task exception={}", e);
//            return ResultUtil.fail();
//        }
//    }

//    @PostMapping("/task")
//    @ResponseBody
//    public TaskResultObj scheduleJob(@RequestBody JobParam jobParam) {
//
//        String  taskno="fx_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType();
//        String cztaskno="cz_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType();
//        QuartzTaskInformations taskInformations = new QuartzTaskInformations();
//        taskInformations.setExecuteparamter(jobParam.getDeviceId());
//        taskInformations.setMetatype(jobParam.getDetectType());
//        //查询是否有抽帧服务
//        List<QuartzTaskInformations> tasks = quartzService.getTaskSByDeviceCode(jobParam.getDeviceId());
//        Map<String, Integer> map = getTaskCzAndFxNumer(tasks);
//        Integer cznum = map.get("cznum");
//        Integer fxnum = map.get("fxnum");
//        Long[] roiarray=new  Long[4];
//        if ("0".equals(jobParam.getType())) {//0新增 1开启 2停止 3删除
//            //判断是否存在抽帧任务，存在则直接新增分析任务，不存在则新增
//            taskInformations.setFrozenstatus("UNFROZEN");
//            taskInformations.setSchedulerrule("*/" + jobParam.getParams().get("schedulerRule").toString() + " * * * * ?");
//            List<Point> listpoint=jobParam.getArea();
//            PointUtil.getXYWH(listpoint,roiarray);
//            taskInformations.setObjectx(roiarray[0]);
//            taskInformations.setObjecty(roiarray[1]);
//            taskInformations.setObjectw(roiarray[2]);
//            taskInformations.setObjecth(roiarray[3]);
//            taskInformations.setMetatype( jobParam.getParams().get("thresholdValue").toString());
//            taskInformations.setUrl(jobParam.getCallBackUrl());
//            taskInformations.setExecutorno(taskno);
//            taskInformations.setTaskno(taskInformations.getExecutorno());
//            taskInformations.setTaskname(jobParam.getName());
//            taskInformations.setVideoid(jobParam.getDeviceId() );
//            taskInformations.setRecordtype(jobParam.getDetectType());
//            String result = quartzService.addTask(taskInformations);
//            try {
//                quartzService.startJob(taskno, "UNFROZEN");
//            }catch (Exception ex){
//                logger.error(taskno+"   fx startJob error:"+ex.toString());
//            }
//            //查询是否有抽帧服务
//            if (cznum == 0) {
//                taskInformations.setExecutorno(cztaskno);
//                taskInformations.setTaskno(cztaskno);
//                quartzService.addTask(taskInformations);
//                try {
//                    quartzService.startJob(cztaskno, "UNFROZEN");
//                }catch (Exception ex){
//                    logger.error(cztaskno+"cz startJob error:"+ex.toString());
//                }
//            }
//        } else if ("1".equals(jobParam.getType()))//开启
//        {
//            try {
//                if (fxnum == 1) {
//                    quartzService.startOrStopJob(cztaskno,"UNFROZEN");
//                 }//开启分析服务,开启抽帧
//                quartzService.startOrStopJob(taskno,"UNFROZEN");
//            } catch (Exception ex) {
//                logger.error(ex.toString());
//            }
//        } else if ("2".equals(jobParam.getType()) ) {//停止
//            //一抽帧多分析,停止不停抽帧服务
//            try {
//                if (fxnum == 1) {
//                    quartzService.startOrStopJob(cztaskno,"FROZEN");
//                }
//                quartzService.startOrStopJob(taskno, "FROZEN");
//            } catch (Exception ex) {
//                logger.error(ex.toString());
//            }
//            } else if ("3".equals(jobParam.getType())) {//删除
//               try {
//                quartzService.startOrStopJob(taskno, "FROZEN");
//                quartzService.deletetask(taskno);
//                if(fxnum==1){
//                    quartzService.startOrStopJob(cztaskno, "FROZEN");
//                    quartzService.deletetask(cztaskno);
//                }
//
//            } catch (Exception ex) {
//                logger.error(ex.toString());
//            }
//            //quartzService.("fx_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType(), fxnum);
//        }
//        return TaskResultObj.ok();
//    }
@PostMapping("/task")
@ResponseBody
public TaskResultObj scheduleJob(@RequestBody JobParam jobParam) {
    String objstr="0";
    if(null!=jobParam.getParams().get("objectType")){
        objstr=jobParam.getParams().get("objectType").toString();
    }
    String taskno="fx_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType()+"_"+objstr;
    if(null!=jobParam.getParams().get("taskno")) {
        taskno = jobParam.getParams().get("taskno").toString();
    }
    QuartzTaskInformations taskInformations = new QuartzTaskInformations();
    taskInformations.setExecuteparamter(jobParam.getDeviceId());
    taskInformations.setMetatype(jobParam.getDetectType());
    Long[] roiarray=new  Long[4];
    if ("0".equals(jobParam.getType())) {//0新增 1开启 2停止 3删除
        //判断是否存在抽帧任务，存在则直接新增分析任务，不存在则新增
        taskInformations.setFrozenstatus("UNFROZEN");
        //判断是否是全天的检测
        if(null!=jobParam.getParams().get("schedulerRule") && jobParam.getParams().get("schedulerRule").toString().indexOf(",")>-1) {
            String[]  schedulerRules=jobParam.getParams().get("schedulerRule").toString().split(",");
            if(schedulerRules.length==3){
                if(schedulerRules[0].equals("") && schedulerRules[1].equals("")) {
                    if(Integer.parseInt(schedulerRules[2])/60>0)
                    {                   //分
                        taskInformations.setSchedulerrule("0 */" + Integer.parseInt(schedulerRules[2])/60 + " * * * ?");
                    }
                    else{
                        taskInformations.setSchedulerrule("*/" + schedulerRules[2]+ " * * * * ?");
                    }

                }else if(!schedulerRules[0].equals("") && !schedulerRules[1].equals(""))
                {
                    //有开始时间结束时间的执行方式
                    if(Integer.parseInt(schedulerRules[2])/60>0)
                    {                   //分 0 */2 8-9 * * *
                        taskInformations.setSchedulerrule("0 */" + Integer.parseInt(schedulerRules[2])/60 + " "+ schedulerRules[0]+"-"+schedulerRules[1]+" * * ?");
                    }
                    else{
                        //秒   0/15 * 6-19 * * ?
                        taskInformations.setSchedulerrule("0/" + schedulerRules[2] + " * "+ schedulerRules[0]+"-"+schedulerRules[1]+" * * ?");
                    }
                }

            }else{
                return   TaskResultObj.error("-1","时间格式错误");
            }
        }
        else{
            return   TaskResultObj.error("-1","执行时间不能为空");
        }

        taskInformations.setObjectType(jobParam.getParams().get("objectType")==null?"1":jobParam.getParams().get("objectType").toString());
        List<Point> listpoint=jobParam.getArea();
        PointUtil.getXYWH(listpoint,roiarray);
        taskInformations.setObjectx(roiarray[0]);
        taskInformations.setObjecty(roiarray[1]);
        taskInformations.setObjectw(roiarray[2]);
        taskInformations.setObjecth(roiarray[3]);
        taskInformations.setMetatype( jobParam.getParams().get("thresholdValue").toString());
        taskInformations.setUrl(jobParam.getCallBackUrl());
        taskInformations.setExecutorno(taskno);
        taskInformations.setTaskno(taskno);
        taskInformations.setTaskname(jobParam.getName());
        taskInformations.setVideoid(jobParam.getDeviceId() );
        taskInformations.setRecordtype(jobParam.getDetectType());
        taskInformations.setSendtype(jobParam.getParams().get("sendType")==null?"1":jobParam.getParams().get("sendType").toString());
        String result = quartzService.addTask(taskInformations);
        Map mapresult=JsonUtil.strToObj(result,Map.class);
        if(null!=mapresult.get("code")&&mapresult.get("code").toString().equals("200")) {
            try {
                quartzService.startJob(taskInformations.getTaskno(), "UNFROZEN");

            } catch (Exception ex) {
                logger.error(taskInformations.getTaskno() + "   fx startJob error:" + ex.toString());
                return TaskResultObj.error("-1", "error");
            }
        }else{
            return   TaskResultObj.error(mapresult.get("code").toString(),mapresult.get("message").toString());
        }
    } else if ("1".equals(jobParam.getType()))//开启
    {
        try {
            quartzService.startOrStopJob(taskno,"UNFROZEN");
        } catch (Exception ex) {
            logger.error(ex.toString());
            return TaskResultObj.error("-1","error");
        }
    } else if ("2".equals(jobParam.getType()) ) {//停止
        //一抽帧多分析,停止不停抽帧服务
        try {
            quartzService.startOrStopJob(taskno, "FROZEN");
        } catch (Exception ex) {
            logger.error(ex.toString());
            return  TaskResultObj.error("-1","error");
        }
    } else if ("3".equals(jobParam.getType())) {//删除
        try {
            quartzService.startOrStopJob(taskno, "FROZEN");
            quartzService.deletetask(taskno);

        } catch (Exception ex) {
            logger.error(ex.toString());
            return TaskResultObj.error("-1","error");
        }
    }
    return TaskResultObj.ok();
}
//
//    @RequestMapping(value = "/edit/taskpage", method = RequestMethod.GET)
//    public String editTaskpage(Model model, String id) {
//        QuartzTaskInformations taskInformation = quartzService.getTaskById(id);
//        taskInformation.setSchedulerrule(taskInformation.getSchedulerrule().replaceAll("\\?", "").replaceAll("\\*", "").replaceAll("\\/", ""));
//        model.addAttribute("taskInformation", taskInformation);
//        return "updatetask";
//    }
//
//    @ResponseBody
//    @RequestMapping(value = "/edit/task", method = RequestMethod.POST)
//    public String editTask(QuartzTaskInformations taskInformations) {
//        try {
//            taskInformations.setSchedulerrule("*/" + taskInformations.getSchedulerrule() + " * * * * ?");
//            String result = quartzService.updateTask(taskInformations);
//            if (null != taskInformations.getExecuteparamter() && !taskInformations.getExecuteparamter().contains("rtsp:")) {
//                int upresult = sbtdspsrService.updateRecogByRtsp(taskInformations.getRtsp(), taskInformations.getVideoid());
//
//                if (upresult > 0) {
//                    logger.info("更新sbtddspsr  squrllj 的值为：" + taskInformations.getExecuteparamter());
//                }
//            }
//            return result;
//        } catch (Exception e) {
//            logger.error("/edit/task exception={}", e);
//            return ResultUtil.fail();
//        }
//    }
//
//    /**
//     * 启动 或者 暂定定时任务
//     *
//     * @param taskNo
//     * @return
//     */
//    @ResponseBody
//    @RequestMapping(value = "/list/optionjob", method = RequestMethod.GET)
//    public String optionJob(String taskNo) {
//        logger.info("");
//        if (StringUtils.isEmpty(taskNo)) {
//            return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
//        }
//        try {
//            return quartzService.startJob(taskNo,null);
//        } catch (Exception e) {
//            logger.error("/list/optionjob exception={}", e);
//            return ResultUtil.fail();
//        }
//    }
//
//    /**
//     * 定时任务执行情况
//     *
//     * @param taskNo
//     * @param model
//     * @return
//     */
//    @RequestMapping(value = "/taskrecords", method = RequestMethod.GET)
//    public String taskRecordsPage(@RequestParam(value = "taskno", required = false) String taskNo, Model model) {
//        logger.info("");
//        try {
//            if (StringUtils.isEmpty(taskNo)) {
//                return "redirect:/";
//            }
//            List<QuartzTaskRecordsVo> quartzTaskRecords = quartzService.taskRecords(taskNo);
//            model.addAttribute("quartzTaskRecords", quartzTaskRecords);
//        } catch (Exception e) {
//            logger.error("");
//            return "redirect:/";
//        }
//        return "taskrecords";
//    }
//
//    /**
//     * 立即运行一次定时任务
//     *
//     * @param taskNo
//     * @param model
//     * @return
//     */
//    @ResponseBody
//    @RequestMapping(value = "/runtask/rightnow", method = RequestMethod.GET)
//    public String runTaskRightNow(@RequestParam(value = "taskno", required = false) String taskNo, Model model) {
//        logger.info("");
//        try {
//            if (StringUtils.isEmpty(taskNo)) {
//                return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
//            }
//            return quartzService.runTaskRightNow(taskNo);
//        } catch (Exception e) {
//            logger.error("");
//            return ResultUtil.success(ResultEnum.FAIL.getCode(), ResultEnum.FAIL.getMessage());
//        }
//    }
//
//    /**
//     * 定时任务失败详情
//     *
//     * @param recordId
//     * @param model
//     * @return
//     */
//    @RequestMapping(value = "/task/errors", method = RequestMethod.GET)
//    public String detailTaskErrors(@RequestParam(value = "recordid", required = false) String recordId, Model model) {
//        logger.info("");
//        try {
//            if (StringUtils.isEmpty(recordId)) {
//                return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
//            }
//            QuartzTaskErrors taskErrors = quartzService.detailTaskErrors(recordId);
//            model.addAttribute("taskErrors", taskErrors);
//            return "taskerrors";
//        } catch (Exception e) {
//            logger.error("");
//            return "redirect:/";
//        }
//    }

//    @RequestMapping(value = "/getRtsp", method = RequestMethod.POST)
//    @ResponseBody
//    public String getRTSP(@RequestBody JSONObject devicecode) {
//        //判断rtsp  是否过期http://212.129.142.17:8281/gh/device/test?deviceCode=3YSCA44445TFCPX
//         //判断是否是rtsp  地址
//        String rtspValue = devicecode.getString("data");
//        if (!rtspValue.contains("rtsp://")) {
//            Map<String, String> map = new HashMap<>();
//            map.put("deviceCode", rtspValue);
//            ResponseEntity<String> responseEntity = restTemplate.getForEntity(getrtspbyurl + "?deviceCode={deviceCode}", String.class, map);
//            JSONObject json = JSONObject.parseObject(responseEntity.getBody());
//            if (null != json.getString("errorCode") && json.getString("errorCode").equals("0")) {
//                //返回rtsp  地址，更新 sbtdspsr  地址
//                json = JSONObject.parseObject(json.getString("data"));
//                rtspValue = String.valueOf(json.get("rtspUri"));
//            }
//        }
//
//        //获得抽帧图片
//        Map maps = new HashMap<>();
//        maps.put("rtspvalue", rtspValue);
//        maps.put("refresh", 1);
//        try {
//            ResponseEntity<String> result = restTemplate.exchange(rtspurl + "?url={rtspvalue}&refresh={refresh}",
//                    HttpMethod.GET, null, String.class, maps);
//            JSONObject jsonresult = JSONObject.parseObject(result.getBody());
//            logger.info("getRtsp:{}", jsonresult);
//            if (null != jsonresult.getString("ret") && jsonresult.getString("ret").equals("0") && !"".equals(jsonresult.getString("url"))) {
//                //获得图片地址,存放到ftp上面
//                //将图片存储到ftp 上去，jsonresult.getString("url")
//                Ftp ftp = ftpService.reloadFtp();
//                String ftpfilepath = FileTransferManager.urlTransToFtp(jsonresult.getString("url"), ftp, "gstraff/picturedemo/");
//                logger.info("ftppath" + ftpfilepath);
//                ftpfilepath = ftpfilepath.replace("ftp://" + ftppath + "/", "");
//                //                return ResultUtil.success(ResultEnum.SUCCESS.getCode(), jsonresult.getString("url")+ "," + rtspValue);
//
//                return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ftpfilepath + "," + rtspValue);
//            }
//            return ResultUtil.fail();
//        } catch (Exception ex) {
//            logger.info(ex.toString());
//            return ResultUtil.fail();
//        }
//    }
}
