package com.cx.cn.cxquartz.job;

import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.service.quartz.QuartzService;
import com.cx.cn.cxquartz.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicInteger;

@Component
public class KafkaListener {

    @Autowired
    private QuartzService quartzService;

    private static final Logger logger = LoggerFactory.getLogger(KafkaListener.class);

    private AtomicInteger atomicInteger;

    public void messageConsumerHandler(String content) {
        logger.info("监听到消息:{}", content);
        atomicInteger = new AtomicInteger(0);
        String id = "";
        String taskNo = "";
        try {
            // message格式 ---------> taskNo:id:executeParameter;
            String[] split = ":".split(content);
            id = split[1];
            taskNo = split[0];
            //TODO kafka逻辑

        } catch (Exception ex) {
            logger.error("");
            atomicInteger.incrementAndGet();
            quartzService.addTaskErrorRecord(id, taskNo + ":" + ex.getMessage(), CommonUtil.getExceptionDetail(ex));
        }
        quartzService.updateRecordById(atomicInteger.get(), Long.parseLong(id));
        QuartzTaskInformations quartzTaskInformation = new QuartzTaskInformations();
        quartzTaskInformation.setId(Long.parseLong(id));
        quartzTaskInformation.setLastmodifytime(System.currentTimeMillis());
        quartzService.updateTask(quartzTaskInformation);
    }

}
