package com.cx.cn.cxquartz.controller;


import com.alibaba.fastjson.JSONObject;
import com.cx.cn.cxquartz.bean.QuartzTaskErrors;
import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.service.quartz.FtpService;
import com.cx.cn.cxquartz.service.quartz.QuartzService;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/ai")
public class QuartzController {

    private static final Logger logger = LoggerFactory.getLogger(QuartzController.class);

    @Autowired
    private QuartzService quartzService;

    @Value("${file.getrtspbyurl}")
    private String getrtspbyurl;

    @Value("${file.rtspurl}")
    private String rtspurl;


    @Value("${file.ftppath}")
    private String ftppath;


    @Autowired
    private SbtdspsrService sbtdspsrService;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    FtpService ftpService;

    @RequestMapping(value = "/add/taskpage", method = RequestMethod.GET)
    public String addTaskpage() {
        return "addtask";
    }

    @ResponseBody
    @RequestMapping(value = "/add/task", method = RequestMethod.POST)
    public String addTask(QuartzTaskInformations taskInformations) {
        try {
            taskInformations.setSchedulerrule("*/" + taskInformations.getSchedulerrule() + " * * * * ?");
            String result = quartzService.addTask(taskInformations);
            return result;
        } catch (Exception e) {
            logger.error("/add/task exception={}", e);
            return ResultUtil.fail();
        }
    }

    @PostMapping("/task")
    @ResponseBody
    public TaskResultObj scheduleJob(@RequestBody JobParam jobParam) {

        String  taskno="fx_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType();
        QuartzTaskInformations taskInformations = new QuartzTaskInformations();
        taskInformations.setExecuteparamter(jobParam.getDeviceId());
        taskInformations.setMetatype(jobParam.getDetectType());
        //查询是否有抽帧服务
       // List<QuartzTaskInformations> tasks = quartzService.getTaskSByDeviceCode(jobParam.getDeviceId());
       // Map<String, Integer> map = getTaskCzAndFxNumer(tasks);
        //Integer cznum = map.get("cznum");
        //Integer fxnum = map.get("fxnum");
        Long[] roiarray=new  Long[4];
        if ("0".equals(jobParam.getType())) {//0新增 1开启 2停止 3删除
            //判断是否存在抽帧任务，存在则直接新增分析任务，不存在则新增
            taskInformations.setFrozenstatus("UNFROZEN");
            taskInformations.setSchedulerrule("*/" + jobParam.getParams().get("schedulerRule").toString() + " * * * * ?");
            List<Point> listpoint=jobParam.getArea();
            PointUtil.getXYWH(listpoint,roiarray);
            taskInformations.setObjectx(roiarray[0]);
            taskInformations.setObjecty(roiarray[1]);
            taskInformations.setObjectw(roiarray[2]);
            taskInformations.setObjecth(roiarray[3]);
            taskInformations.setMetatype( jobParam.getParams().get("thresholdValue").toString());
            taskInformations.setUrl(jobParam.getCallBackUrl());
            taskInformations.setExecutorno(taskno);
            taskInformations.setTaskno(taskInformations.getExecutorno());
            taskInformations.setTaskname(jobParam.getName());
            taskInformations.setVideoid(jobParam.getDeviceId() );
            taskInformations.setRecordtype(jobParam.getDetectType());
            String result = quartzService.addTask(taskInformations);
            //查询是否有抽帧服务
            //if (cznum == 0) {
              //  taskInformations.setExecutorno("cz_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType());
              //  taskInformations.setTaskno(taskInformations.getExecutorno());
             //   quartzService.addTask(taskInformations);
           // }
        } else if ("1".equals(jobParam.getType()))//开启
        {
            try {
                quartzService.startOrStopJob(taskno,"UNFROZEN");
            } catch (Exception ex) {

            }
        } else if ("2".equals(jobParam.getType()) ) {//停止
            //一抽帧多分析,停止不停抽帧服务
            try {
                quartzService.startOrStopJob(taskno, "FROZEN");
            } catch (Exception ex) {

            }
            } else if ("3".equals(jobParam.getType())) {//删除
            //一抽帧多分析,停止不停抽帧服务
            try {
                quartzService.startOrStopJob(taskno, "FROZEN");
                quartzService.deletetask(taskno);
            } catch (Exception ex) {

            }
            //quartzService.("fx_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType(), fxnum);
        }
        return TaskResultObj.ok();
    }

    public Map getTaskCzAndFxNumer(List<QuartzTaskInformations> tasks) {
        Map<String, Integer> map = new HashMap();

        int cznum = 0, fxnum = 0;
        if (tasks.size() > 0) {
            //一抽多分析
            for (QuartzTaskInformations item : tasks) {
                if (item.getTaskno().contains("cz")) {
                    cznum++;
                } else if (item.getTaskno().contains("fx")) {
                    fxnum++;
                }
            }
        }
        map.put("cznum", cznum);
        map.put("fxnum", fxnum);
        return map;

    }

    @RequestMapping(value = "/edit/taskpage", method = RequestMethod.GET)
    public String editTaskpage(Model model, String id) {
        QuartzTaskInformations taskInformation = quartzService.getTaskById(id);
        taskInformation.setSchedulerrule(taskInformation.getSchedulerrule().replaceAll("\\?", "").replaceAll("\\*", "").replaceAll("\\/", ""));
        model.addAttribute("taskInformation", taskInformation);
        return "updatetask";
    }

    @ResponseBody
    @RequestMapping(value = "/edit/task", method = RequestMethod.POST)
    public String editTask(QuartzTaskInformations taskInformations) {
        try {
            taskInformations.setSchedulerrule("*/" + taskInformations.getSchedulerrule() + " * * * * ?");
            String result = quartzService.updateTask(taskInformations);
            if (null != taskInformations.getExecuteparamter() && !taskInformations.getExecuteparamter().contains("rtsp:")) {
                int upresult = sbtdspsrService.updateRecogByRtsp(taskInformations.getRtsp(), taskInformations.getVideoid());

                if (upresult > 0) {
                    logger.info("更新sbtddspsr  squrllj 的值为：" + taskInformations.getExecuteparamter());
                }
            }
            return result;
        } catch (Exception e) {
            logger.error("/edit/task exception={}", e);
            return ResultUtil.fail();
        }
    }

    /**
     * 启动 或者 暂定定时任务
     *
     * @param taskNo
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/list/optionjob", method = RequestMethod.GET)
    public String optionJob(String taskNo) {
        logger.info("");
        if (StringUtils.isEmpty(taskNo)) {
            return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
        }
        try {
            return quartzService.startJob(taskNo,null);
        } catch (Exception e) {
            logger.error("/list/optionjob exception={}", e);
            return ResultUtil.fail();
        }
    }

    /**
     * 定时任务执行情况
     *
     * @param taskNo
     * @param model
     * @return
     */
    @RequestMapping(value = "/taskrecords", method = RequestMethod.GET)
    public String taskRecordsPage(@RequestParam(value = "taskno", required = false) String taskNo, Model model) {
        logger.info("");
        try {
            if (StringUtils.isEmpty(taskNo)) {
                return "redirect:/";
            }
            List<QuartzTaskRecordsVo> quartzTaskRecords = quartzService.taskRecords(taskNo);
            model.addAttribute("quartzTaskRecords", quartzTaskRecords);
        } catch (Exception e) {
            logger.error("");
            return "redirect:/";
        }
        return "taskrecords";
    }

    /**
     * 立即运行一次定时任务
     *
     * @param taskNo
     * @param model
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/runtask/rightnow", method = RequestMethod.GET)
    public String runTaskRightNow(@RequestParam(value = "taskno", required = false) String taskNo, Model model) {
        logger.info("");
        try {
            if (StringUtils.isEmpty(taskNo)) {
                return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
            }
            return quartzService.runTaskRightNow(taskNo);
        } catch (Exception e) {
            logger.error("");
            return ResultUtil.success(ResultEnum.FAIL.getCode(), ResultEnum.FAIL.getMessage());
        }
    }

    /**
     * 定时任务失败详情
     *
     * @param recordId
     * @param model
     * @return
     */
    @RequestMapping(value = "/task/errors", method = RequestMethod.GET)
    public String detailTaskErrors(@RequestParam(value = "recordid", required = false) String recordId, Model model) {
        logger.info("");
        try {
            if (StringUtils.isEmpty(recordId)) {
                return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
            }
            QuartzTaskErrors taskErrors = quartzService.detailTaskErrors(recordId);
            model.addAttribute("taskErrors", taskErrors);
            return "taskerrors";
        } catch (Exception e) {
            logger.error("");
            return "redirect:/";
        }
    }

    @RequestMapping(value = "/getRtsp", method = RequestMethod.POST)
    @ResponseBody
    public String getRTSP(@RequestBody JSONObject devicecode) {
        //判断rtsp  是否过期http://212.129.142.17:8281/gh/device/test?deviceCode=3YSCA44445TFCPX
         //判断是否是rtsp  地址
        String rtspValue = devicecode.getString("data");
        if (!rtspValue.contains("rtsp://")) {
            Map<String, String> map = new HashMap<>();
            map.put("deviceCode", rtspValue);
            ResponseEntity<String> responseEntity = restTemplate.getForEntity(getrtspbyurl + "?deviceCode={deviceCode}", String.class, map);
            JSONObject json = JSONObject.parseObject(responseEntity.getBody());
            if (null != json.getString("errorCode") && json.getString("errorCode").equals("0")) {
                //返回rtsp  地址，更新 sbtdspsr  地址
                json = JSONObject.parseObject(json.getString("data"));
                rtspValue = String.valueOf(json.get("rtspUri"));
            }
        }

        //获得抽帧图片
        Map maps = new HashMap<>();
        maps.put("rtspvalue", rtspValue);
        maps.put("refresh", 1);
        try {
            ResponseEntity<String> result = restTemplate.exchange(rtspurl + "?url={rtspvalue}&refresh={refresh}",
                    HttpMethod.GET, null, String.class, maps);
            JSONObject jsonresult = JSONObject.parseObject(result.getBody());
            logger.info("getRtsp:{}", jsonresult);
            if (null != jsonresult.getString("ret") && jsonresult.getString("ret").equals("0") && !"".equals(jsonresult.getString("url"))) {
                //获得图片地址,存放到ftp上面
                //将图片存储到ftp 上去，jsonresult.getString("url")
                Ftp ftp = ftpService.reloadFtp();
                String ftpfilepath = FileTransferManager.urlTransToFtp(jsonresult.getString("url"), ftp, "gstraff/picturedemo/");
                logger.info("ftppath" + ftpfilepath);
                ftpfilepath = ftpfilepath.replace("ftp://" + ftppath + "/", "");
                //                return ResultUtil.success(ResultEnum.SUCCESS.getCode(), jsonresult.getString("url")+ "," + rtspValue);

                return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ftpfilepath + "," + rtspValue);
            }
            return ResultUtil.fail();
        } catch (Exception ex) {
            logger.info(ex.toString());
            return ResultUtil.fail();
        }
    }
}
