package com.cx.cn.cxquartz.redis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class OrderProducer implements  Producer {
    public static final Logger log = LoggerFactory.getLogger(OrderProducer.class);
    @Autowired
    private RedisTemplate redisTemplate;


    public OrderProducer(){

    }

    @Override
    public void produce(String queue,Object message) {
        redisTemplate.opsForList().leftPush(queue,message);//消息左入
        log.info("添加消息到队列:{}",message.toString());
    }
}
