package com.cx.cn.cxquartz.job;

import com.cx.cn.cxquartz.redis.QueueSender;
import com.cx.cn.cxquartz.util.ApplicationContextHolder;
import org.quartz.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import java.util.concurrent.atomic.AtomicInteger;

@DisallowConcurrentExecution
public class QuartzMainJobFactory implements Job {

    private static Logger logger = LoggerFactory.getLogger(QuartzMainJobFactory.class);

    private AtomicInteger atomicInteger;

    @Value("${local.czurl}")
    private String czurl;
    @Value("${local.fxurl}")
    private String fxurl;
//    @Autowired
//    private QueueSender queueSender;

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        atomicInteger = new AtomicInteger(0);
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        QueueSender qeueSender = (QueueSender) ApplicationContextHolder.getBean("queueSender");
        try {
            //根据事件类型进行通道分配
            qeueSender.sendMsg("taskinfo", jobDataMap.get("taskinfo"));
        }catch (Exception  ex){
            logger.error("Scheduler executing error:{}",ex);
        }
//       String taskNo = jobDataMap.getString("taskNo");  String executorNo = jobDataMap.getString("executorNo");
//        String url = jobDataMap.getString("url");
//        String executeParameter = jobDataMap.getString("executeParameter");
//        logger.info("定时任务被执行:taskNo={},executorNo={},url={},executeParameter={}", taskNo, executorNo, url, executeParameter);
//        QuartzService quartzService = (QuartzServiceImpl) ApplicationContextHolder.getBean("quartzServiceImpl");
//        QuartzTaskRecords records = null;
//        try {
//            //保存定时任务的执行记录
//            records = quartzService.addTaskRecords(taskNo);
//            if (null == records || !ResultEnum.INIT.name().equals(records.getTaskstatus())) {
//                logger.info("taskNo={}保存执行记录失败", taskNo);
//                return;
//            }
//
//            //if (ResultEnum.HTTP.getMessage().equals(sendType)) {
//                try {
//                    String result = HttpClientUtil.doPost(taskNo.contains("cz_") ? czurl : fxurl, "text/json", executeParameter);
//                    logger.info("taskNo={},执行结果result{}", taskNo, result);
//                    if (StringUtils.isEmpty(result)) {
//                        throw new RuntimeException("taskNo=" + taskNo + "http方式返回null");
//                    }
//                } catch (Exception ex) {
//                    logger.error("");
//                    throw ex;
//                }
////            } else if (ResultEnum.KAFKA.getMessage().equals(sendType)) {
////                try {
////                    String message = new StringBuffer(taskNo).append(":").append(id).append(":").append(executeParameter).toString();
////                    quartzService.sendMessage(message);
////                    logger.info("taskNo={},sendtype={}推送至kafka成功", taskNo, sendType);
////                } catch (Exception ex) {
////                    logger.error("");
////                    throw ex;
////                }
////            }
//        } catch (Exception ex) {
//            String exception=CommonUtil.getExceptionDetail(ex);
//            logger.error(exception);
//            atomicInteger.incrementAndGet();
//            quartzService.addTaskErrorRecord(records.getId().toString(), taskNo + ":" + ex.getMessage(), exception);
//        }
       // quartzService.updateRecordById(atomicInteger.get(), records.getId());
        //QuartzTaskInformations quartzTaskInformation = new QuartzTaskInformations();
        //quartzTaskInformation.setId(Long.parseLong(id));
        //quartzTaskInformation.setLastmodifytime(System.currentTimeMillis());
        //quartzService.updateTask(quartzTaskInformation);
    }
}
