package com.cx.cn.cxquartz.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cx.cn.cxquartz.bean.PatrolCtrlAlarm;
import com.cx.cn.cxquartz.bean.PatrolCtrlRecord;
import com.cx.cn.cxquartz.bean.PictureTime;
import com.cx.cn.cxquartz.job.WebSocket;
import com.cx.cn.cxquartz.service.quartz.*;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.concurrent.*;

@RestController
@RequestMapping("/ext")
@PropertySource("classpath:file.properties")
public class ExtController {

    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);

    @Autowired
    private QuartzService quartzService;

    @Value("${file.uploadpath}")
    private String uploadpath;

    @Value("${file.alarmpath}")
    private String alarmpath;

    @Value("${file.alarmurl}")
    private String alarmurl;

    @Value("${file.recordurl}")
    private String recordurl;

    @Value("${file.rtspurl}")
    private String rtspurl;

    @Value("${file.recogurl}")
    private String recogurl;


    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private SbtdspsrService sbtdspsrService;

    @Autowired
    FtpService ftpService;

    @Autowired
    private QuartzTaskInformationsService quartzTaskInformationsService;

    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;

    @Autowired
    TraffPictureService traffPictureService;


    @Autowired
    PedestrianService  pedestrianService;

    @Autowired
    TrafficService  trafficService;

    @Autowired
    FaceService  faceService;

    @Autowired
    PeopleridebicycService  peopleridebicycService;

    @Autowired
    WebSocket webSocket;
    private static CompletionService<PictureResult> threadService = new ExecutorCompletionService<PictureResult>(ThreadPoolUtil.getPool());

    @RequestMapping(value = "/patrolCtrlRecord", method = RequestMethod.POST)
    public String upload(HttpServletRequest request) {
        try {
            //判断表中各监控设备id 的最新记录时间，如果为空则进行监控数据更新，不为空则获得上一次各个设备最新的截图时间
            //遍历list 从  最新的记录时间开始
            HttpSession session = request.getSession();
            int result = 0, resultSuccess = 0, alarmresultSuccess = 0;
            List<String> resultlist = new ArrayList<>();
            String[] fileParam = null;//文件名称数组
            String filename = "", fileatream = "", picturetime;//文件名拼接成的日期,图片生成时间
            SimpleDateFormat simpledate = new SimpleDateFormat("yyyyMMddHHmmss"), newsimpledate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//日期转换成特定格式
            List<File> newfilelist = new ArrayList<>();
            RecursiveGetJsonData fileutil = new RecursiveGetJsonData();
            fileutil.getDataFromFile(uploadpath, "jpeg");
            List<File> jsonFile = fileutil.getJsonFileList();        //获得文件夹下所有文件信息
            List<PictureTime> picturses = quartzService.findLastPicTime();//查询各个设备最新的记录时间
            CommonUtil.removeFinishFiles(jsonFile, picturses);//去除重复文件
            List<String> deviceids = new ArrayList<>();
            for (File file : jsonFile) {
                fileParam = file.getAbsolutePath().split("\\\\");
                deviceids.add(fileParam[fileParam.length - 3]);
            }
            //查询该设备的国标码
            List<PatrolCtrlRecord> recordList = quartzService.queryCameraCode(deviceids);
            if (jsonFile.size() > 0) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add("access-token", session.getAttribute("token").toString());
                ExecutorService fixedThreadPool = Executors.newFixedThreadPool(5);
                for (File file : jsonFile) {
                    fixedThreadPool.execute(new Runnable() {
                        public void run() {
                            String[] fileParam = file.getAbsolutePath().split("\\\\");
                            String filename = fileParam[fileParam.length - 2] + fileParam[fileParam.length - 1].replace(".jpeg", "");
                            if (null != fileParam && fileParam.length > 4) {
                                String fileatream = fileutil.ImageToBase64ByLocal(file);
                                for (PatrolCtrlRecord record : recordList) {
                                    if (record.getDeviceid().equals(fileParam[fileParam.length - 3])) {
                                        try {
                                            String picturetime = newsimpledate.format(simpledate.parse(filename));
                                            record.setPatrolTime(picturetime);
                                            record.setRecordSrc("2");
                                            record.setFile(fileatream);
                                            //调用推送接口
                                            HttpEntity<String> requestEntity = new HttpEntity<String>(JSONObject.toJSONString(record), headers);
                                            ResponseEntity<String> response = restTemplate.exchange(recordurl, HttpMethod.POST, requestEntity, String.class);
                                            String body = response.getBody();
                                            JSONObject json = JSONObject.parseObject(body);
                                            if (null != json.getString("status") && json.getString("status").equals("0")) {
                                                record.setFile(null);
                                                record.setPatrolTime(filename);
                                                quartzService.insertRecord(record);
                                                logger.info("ext/patrolCtrlRecord  success-->" + file.getAbsolutePath());
                                            } else {
                                                logger.info("ext/patrolCtrlRecord  fail-->" + fileParam[fileParam.length - 1] + body);
                                            }
                                            PatrolCtrlAlarm alarm = new PatrolCtrlAlarm();
                                            alarm.setCameraCode(record.getCameraCode());
                                            alarm.setCameraName(record.getCameraName());
                                            alarm.setFile(fileatream);
                                            alarm.setTime(picturetime);
                                            alarm.setType("2");
                                            //调用告警接口
                                            ResponseEntity<String> alarmresponse = restTemplate.exchange(alarmurl, HttpMethod.POST, new HttpEntity<String>(JSONObject.toJSONString(alarm), headers), String.class);
                                            JSONObject alarmjson = JSONObject.parseObject(alarmresponse.getBody());
                                            if (null != alarmjson.getString("status") && alarmjson.getString("status").equals("0")) {
                                                alarm.setFile(null);
                                                alarm.setTime(filename);
                                                quartzService.insertAlarm(alarm);
                                                logger.info("ext/alarm  success-->" + file.getAbsolutePath());
                                            } else {
                                                logger.info("ext/alarm  fail-->" + fileParam[fileParam.length - 1] + alarmresponse.getBody());
                                            }
                                        } catch (Exception e) {
                                            logger.error("ext/patrolCtrlRecord-->" + e.toString());
                                        }
                                    }
                                }
                            }


                        }
                    });
                    logger.info("ext/patrolCtrlRecord  success-->" + "总共" + jsonFile.size() + "张，推送成功" + resultSuccess + "张，告警成功" + alarmresultSuccess + "张");
                }


            }
            return ResultUtil.success();
        } catch (Exception e) {
            logger.error("ext/patrolCtrlRecord-->" + e.toString());
        }
        return ResultUtil.fail();
    }

    @RequestMapping(value = "/getRTSP/{photonum}", method = RequestMethod.POST)
    public String getrtsp(HttpServletRequest request,
                          @RequestBody String rtspValue,
                          @PathVariable("photonum") Integer photonum) {
        try {
            //根据判断监控是否存在
            List<Sbtdspsr> sbtdspsrs = sbtdspsrService.selectByRtsp(rtspValue);
            if (sbtdspsrs.size() > 0) {
                Sbtdspsr sbtdspsr = sbtdspsrs.get(0);
                //根据rtsp 进行图片获取及存储
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                Map<String, Object> maps = new HashMap<String, Object>();
                maps.put("rtspvalue", rtspValue);
                maps.put("refresh",1);
                HttpEntity<String> formEntity = new HttpEntity<String>(null, headers);
                TraffAlarmRecord record = new TraffAlarmRecord();
                Map<String, Object> transferRecordMap = new HashMap<>();
                List<String> imgUrls = new ArrayList<>();
                TraffAlarmRecord traffAlarmRecord = new TraffAlarmRecord();
                traffAlarmRecord.setFdid(sbtdspsr.getSbbh());
                traffAlarmRecord.setChannelid(Integer.parseInt(String.valueOf(sbtdspsr.getTdbh())));
                traffAlarmRecord.setAreaid(Long.parseLong(sbtdspsr.getXzbh()));
                for (int i = 0; i < photonum; i++) {//photonum张图片，最多5张
                    if (i > 4) break;
                    ResponseEntity<String> exchange = restTemplate.exchange(rtspurl + "?url={rtspvalue}&refresh={refresh}",
                            HttpMethod.GET, formEntity, String.class, maps);
                    String body = exchange.getBody();
                    JSONObject json = JSONObject.parseObject(exchange.getBody());
                    if (null != json.getString("ret") && json.getString("ret").equals("0")) {
                        //获得图片地址
                        imgUrls.add(json.getString("url"));
                    }
                }
                traffAlarmRecord.setCreatetime(new Date());
                traffAlarmRecord.setPushstatus(9);
                traffAlarmRecord.setCheckstatus(9);//免审
                traffAlarmRecord.setProcessstatus("-2");//未提取特征
                //存储到ftp 上去
                for (int i = 0; i < imgUrls.size(); i++) {
                    TraffAlarmRecordFromImgEnum.valueOf("IMG" + i).setImg(traffAlarmRecord, imgUrls.get(i));
                }
                String basepath = "gstraff/" + traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
                Ftp ftp = ftpService.reloadFtp();

                //入表
                Long  recordid=Long.parseLong(String.valueOf(traffAlarmRecordService.inserTraffAlarmRecord(traffAlarmRecord)));
                FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
                List<TransferResult> results = FileTransferManager.transferFile(transferRecordMap, ftp, basepath);
//                logger.info("缓存数据上传结果：" + results.toString());
                    TraffAlarmRecord recordBak = FileTransferManager.traffAlarmRecordUrlUpdate(results);
                traffAlarmRecord.setImg1path(recordBak.getImg1path());
                traffAlarmRecord.setImg2path(recordBak.getImg2path());
                traffAlarmRecord.setImg3path(recordBak.getImg3path());
                traffAlarmRecord.setImg4path(recordBak.getImg4path());
                traffAlarmRecord.setImg5path(recordBak.getImg5path());
                traffAlarmRecord.setVideopath(recordBak.getVideopath());
                //更新图片地址
                traffAlarmRecordService.updateTraffAlarmRecordUrl(traffAlarmRecord);
                return ResultUtil.success();
            }
            logger.error("rtsp 不存在-->");
            return ResultUtil.fail();
        } catch (Exception e) {
            logger.error("ext/patrolCtrlRecord-->" + e.toString());
        }
        return ResultUtil.fail();
    }

    @RequestMapping(value = "/getRecog", method = RequestMethod.POST)
    public String getRecog(HttpServletRequest request,  @RequestBody String rtspValue) {
            //根据判断监控是否存在，该监控检测的事件是什么
            List<String> video_model = sbtdspsrService.selectRecogByRtsp(rtspValue);
            if (null!=video_model &&!video_model.equals("") && video_model.size()>0 ) {
                //获得该监控的检测业务
                String model = video_model.get(0).split("/")[1];
                String videoid = video_model.get(0).split("/")[0];
                //查询该监控下面还没有经过分析的数据
                Map<String, Object> map = new HashMap<>();
                map.put("sbbh", videoid.split("_")[0]);
                map.put("tdbh", videoid.split("_")[1]);
                List<TraffAlarmRecord> traffalarmrecordlist = traffAlarmRecordService.getTraffAlarmRecordByProgress(map);
                BASE64Decoder base64Decoder=new BASE64Decoder();
                int count = 0;
                //开启多线程
                //调用结构化服务，获得图片返回结果
                HttpHeaders headers = new HttpHeaders();
                BASE64Encoder base64Encoder = new BASE64Encoder();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                HttpEntity<String> requestEntity=null;
                Map websocketmap=new HashMap();
                for (TraffAlarmRecord transferRecord : traffalarmrecordlist) {
                    count = 0;
                    GoalStructureParam param = FileTransferManager.getGoalStructureParam(count, Integer.parseInt(model == null ? "1" : model.equals("") ? "1" : model), base64Encoder, transferRecord);
                   if(param.getImageList().size()<1)continue;
                    requestEntity= new HttpEntity<String>(JSONObject.toJSONString(param), headers);
                    ResponseEntity<String> response = restTemplate.exchange(recogurl, HttpMethod.POST, requestEntity, String.class);
                    JSONObject result = JSONObject.parseObject(response.getBody());
                    if (null != result.get("ret") && result.get("ret").equals("200")) {
                        //获得返回结果,根据 Metadata.type 判断是人，车，人骑车，并将详细信息入对应的表
                        List<TraffpictureParam> objectList = (List<TraffpictureParam>) JSONArray.parseArray(String.valueOf(result.get("ObjectList")), TraffpictureParam.class);
                        //获得 type

                        //更新 recordalarm 为一分析
                        traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
                        for (TraffpictureParam traffpictureParam : objectList) {
                            //根据imageid  获得  base64图片
                            JSONObject metadata = JSONObject.parseObject(String.valueOf(traffpictureParam.getMetadata()));
                            traffpictureParam.setAreaid(transferRecord.getAreaid());
                            traffpictureParam.setFdid(transferRecord.getFdid());
                            traffpictureParam.setChannelid(transferRecord.getChannelid());
                            traffpictureParam.setRecordid(transferRecord.getRecordid());
                            traffpictureParam.setRecordtype(String.valueOf(metadata.get("Type")));
                            traffpictureParam.setProcessstatus("0");
                            //获得imgid  对应的 base64
                            String  imgftpurl=traffPictureService.queryimgpath(traffpictureParam);
                            Ftp ftp = ftpService.reloadFtp();

                            if (null != imgftpurl && !"".equals(imgftpurl)) {
                                byte[] Img = FTPUtil.getFtpPicBytes(imgftpurl);
                                if(null!=Img) {
                                    traffpictureParam.setImagedata(base64Encoder.encode(Img));
                                }
                            }
                            traffpictureParam.setCreatetime(DateUtils.getNowDate());
                            //新增到picture
                            int id = traffPictureService.inserTraffpicture(traffpictureParam);
                            //将新增的结果返回到前端
                            websocketmap.clear();
                            websocketmap.put("data",traffpictureParam);
                            websocketmap.put("id",traffpictureParam.getId());
                            websocketmap.put("recordtime",DateUtils.formatDateTime(traffpictureParam.getCreatetime()));
                            websocketmap.put("videdoid",traffpictureParam.getFdid()+"_"+traffpictureParam.getFdid());
                            WebSocket.GroupSending(JSONObject.toJSONString(websocketmap));
                            if (null != metadata && metadata.get("Type").equals("1"))//行人
                            {
                                Pedestrian meta = JSON.toJavaObject(metadata, Pedestrian.class);
                                meta.setId(traffpictureParam.getId());
                                pedestrianService.insertpedestrian(meta);
                                //新增到事件详情表返回主键
                                traffpictureParam.setObjx(meta.getObjectBoundingBox().getX());
                                traffpictureParam.setObjy(meta.getObjectBoundingBox().getY());
                                traffpictureParam.setObjw(meta.getObjectBoundingBox().getW());
                                traffpictureParam.setObjh(meta.getObjectBoundingBox().getH());
                            }
                            else  if (null != metadata && metadata.get("Type").equals("2"))//车辆
                            {
                                Traffic meta = JSON.toJavaObject(metadata, Traffic.class);
                                meta.setId(traffpictureParam.getId());
                                //新增到车辆详情表
                                trafficService.insertTraffic(meta);
                                traffpictureParam.setObjx(meta.getObjectBoundingBox().getX());
                                traffpictureParam.setObjy(meta.getObjectBoundingBox().getY());
                                traffpictureParam.setObjw(meta.getObjectBoundingBox().getW());
                                traffpictureParam.setObjh(meta.getObjectBoundingBox().getH());
                            }
                            else  if (null != metadata && metadata.get("Type").equals("3"))
                            {
                                Face meta = JSON.toJavaObject(metadata, Face.class);
                                meta.setId(traffpictureParam.getId());
                                faceService.insertFace(meta);
                                traffpictureParam.setObjx(meta.getFaceBoundingBox().getX());
                                traffpictureParam.setObjy(meta.getFaceBoundingBox().getY());
                                traffpictureParam.setObjw(meta.getFaceBoundingBox().getW());
                                traffpictureParam.setObjh(meta.getFaceBoundingBox().getH());
                            }
                            else  if (null != metadata && metadata.get("Type").equals("4"))//人骑车
                            {
                                PeopleRideBicyc meta = JSON.toJavaObject(metadata, PeopleRideBicyc.class);
                                meta.setId(traffpictureParam.getId());
                                peopleridebicycService.insertPeopleRideBicyc(meta);
                                if(null!=meta.getObjectBoundingBox()) {
                                    traffpictureParam.setObjx(meta.getObjectBoundingBox().getX());
                                    traffpictureParam.setObjy(meta.getObjectBoundingBox().getY());
                                    traffpictureParam.setObjw(meta.getObjectBoundingBox().getW());
                                    traffpictureParam.setObjh(meta.getObjectBoundingBox().getH());
                                }
                            }
                            //更新 traffpicture特征值

                                try {
                                    ByteArrayInputStream bais = new ByteArrayInputStream(base64Decoder.decodeBuffer(traffpictureParam.getImagedata()));
                                    BufferedImage image = ImageIO.read(bais);
                                    Graphics g = image.getGraphics();
                                    g.setColor(Color.RED);//画笔颜色
                                    g.drawRect(traffpictureParam.getObjx(), traffpictureParam.getObjy(), traffpictureParam.getObjw(), traffpictureParam.getObjh());
                                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                                    ImageIO.write(image, "png", stream);
                                    traffpictureParam.setImagedata(new String(Base64.getEncoder().encode(stream.toByteArray())));
                                } catch (Exception ex)
                                {

                                    logger.info("base64画框异常："+ex.toString());
                                }
                            traffPictureService.updateTraffpicture(traffpictureParam);
                        }
                    }

                }
                return ResultUtil.success();
            } else {
                logger.info("监控不属于该范围");
            }
        //更新record 表Progress 字段，0为 未检测，-2 为检测失败，将检测
        //结果进行额外封装入表
        logger.error("rtsp 不存在-->");
        return ResultUtil.fail();
    }


}
