package com.video.ai.controller;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.video.ai.domain.Orders;
import com.video.ai.service.OrdersService;
import com.video.ai.utils.AlipayConfig;
import com.video.ai.utils.DateUtils;
import com.video.ai.utils.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Controller
@RequestMapping("/alipay")
public class AlipayReturnController {
	private static final Logger log = LoggerFactory.getLogger(AliPayController.class);
	@Autowired
	OrdersService service;

	/***
	 * 同步推送订单消息
	 * @param request
	 * @param response
	 */
	@RequestMapping("/returnUrl")
	public String  return_url(HttpServletRequest request, HttpServletResponse response) {
		Map<String, String> params =  getParamByRequest(request);
		log.info("return_url:{}\n", JsonUtil.objToStr(params));
		boolean signVerified = false;
		try {
//			String sign = (String)params.get("sign");
//			log.info("sign:{}\n", sign);
//			String content =AlipaySignature. getSignCheckContentV1(params);
//			log.info("content:{}\n", content);
//			signVerified = AlipaySignature.rsaCheck(content, sign, AlipayConfig.alipay_public_key2, AlipayConfig.charset, AlipayConfig.sign_type);
//			log.info("signVerified:{}\n", signVerified);
			//调用SDK验证签名
			signVerified = AlipaySignature.rsaCheckV1(params, AlipayConfig.alipay_public_key2, AlipayConfig.charset, AlipayConfig.sign_type);
		} catch (AlipayApiException e) {
			e.printStackTrace();
		}
		if (signVerified) {
			//商户订单号
			String out_trade_no = request.getParameter("out_trade_no");
			//支付宝交易号
			String trade_no = request.getParameter("trade_no");
			//根据订单编号更新表中的交易号，
			Orders order=new Orders();
			order.setOrderNum(out_trade_no);
			order.setTradeNo(trade_no);
			service.updateInfoByOrderNum(order);
		} else {
			log.error("验签失败");
		}
			return "success";
	}

	/**
	 * 支付宝订单异步消息同步
	 * @param request
	 */
	@RequestMapping("/notifyUrl")
	public String  notifyurl(HttpServletRequest request) {
	    Map<String, String> params =  getParamByRequest(request);
		log.info("异步 notifyurl: {}\n",JsonUtil.objToStr(params));
		boolean signVerified = false; //调用SDK验证签名
//
//		String sign = (String)params.get("sign");
//		log.info("sign:{}\n", sign);
//		String content =AlipaySignature. getSignCheckContentV1(params);
//		log.info("content:{}\n", content);

		try {
//			signVerified = AlipaySignature.rsaCheck(content, sign, AlipayConfig.alipay_public_key2, AlipayConfig.charset, AlipayConfig.sign_type);
			log.info("signVerified:{}\n", signVerified);
			log.info("异步 alipay_public_key: {}",AlipayConfig.alipay_public_key2);
			signVerified = AlipaySignature.rsaCheckV1(params, AlipayConfig.alipay_public_key2, AlipayConfig.charset,AlipayConfig.sign_type);
		} catch (AlipayApiException e) {
			log.error("调用SDK验证签名error:",e);
		}
		/* 实际验证过程建议商户务必添加以下校验：
		1、需要验证该通知数据中的out_trade_no是否为商户系统中创建的订单号，
		2、判断total_amount是否确实为该订单的实际金额（即商户订单创建时的金额），
		3、校验通知中的seller_id（或者seller_email) 是否为out_trade_no这笔单据的对应的操作方（有的时候，一个商户可能有多个seller_id/seller_email）
		4、验证app_id是否为该商户本身。
		*/

		//支付宝交易号
		String trade_no=params.get("trade_no");
		String out_trade_no =params.get("out_trade_no") ;//商户订单号
		String  paidtime=params.get("gmt_payment");			//交易状态
		String trade_status = params.get("trade_status");
		if(signVerified) {//验证成功
			Orders order=new Orders();
			order.setOrderNum(out_trade_no);
			order.setTradeNo(trade_no);
			order.setOrderStatus("20");//支付订单
			order.setPaidAmount(params.get("receipt_amount"));
			if(trade_status.equals("TRADE_FINISHED")){
				//判断该笔订单是否在商户网站中已经做过处理
				order.setFinishTime(paidtime==null?DateUtils.getTime():paidtime);
			}else if (trade_status.equals("TRADE_SUCCESS")){
				//此状态支付成功状态，但仍可退费等处理
				order.setPaidTime(paidtime==null?DateUtils .getTime():paidtime);

			}
			else if (trade_status.equals("TRADE_CLOSED")){
				order.setOrderStatus("30");//取消
				log.info("异步 TRADE_CLOSED: {}",JsonUtil.objToStr(params));
				//此状态支付成功状态，但仍可退费等处理
				order.setPaidTime(paidtime==null?DateUtils .getTime():paidtime);
			}
			//更新订单状态
		     order.setGmtcreatetime(params.get("gmt_payment"));
			service.updateInfoByOrderNum(order);
			log.info("notifyurl success");
		}else {
			//验证失败
			log.error("fail");
		}
		if (trade_status.equals("TRADE_CLOSED")) {
			return "error";
		}
		else {
			return "success";
		}

	}

	private Map<String, String> getParamByRequest(HttpServletRequest request) {
		Map<String, String> params = new HashMap<>();
		Map requestParams = request.getParameterMap();
		for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext(); ) {
			String name = (String) iter.next();
			String[] values = (String[]) requestParams.get(name);
			String valueStr = "";
			for (int i = 0; i < values.length; i++) {

				valueStr = (i == values.length - 1) ? valueStr + values[i] : valueStr + values[i] + ",";
			}
			params.put(name, valueStr);
		}
		return params;
	}

}
