package com.video.ai.service;

import com.github.pagehelper.PageHelper;
import com.video.ai.dao.OrdersDao;
import com.video.ai.domain.AliPayParam;
import com.video.ai.domain.Orders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class OrdersService {

	@Autowired
	private OrdersDao ordersDao;

	public void add(Orders orders) {
		ordersDao.add(orders);
	}

	public void update(Orders orders) {
		ordersDao.update(orders);
	}
	public void updateInfoByOrderNum(Orders orders) {
		ordersDao.updateInfoByOrderNum(orders);
	}


	public List<Orders> findAll() {
		return ordersDao.findAll();
	}

	public Orders findById(String id) {
		return ordersDao.findById(id);
	}

	public  List<Orders> queryByParam(AliPayParam param){
		PageHelper.startPage(param.getPage(),param.getSize());
		return ordersDao.queryByParam(param);
	}
	public Orders findByOrdernum(String id) {
		return ordersDao.findByOrdernum(id);
	}

}
