package com.video.ai.controller;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.github.pagehelper.PageInfo;
import com.video.ai.domain.*;
import com.video.ai.service.OrdersService;
import com.video.ai.utils.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/alipay/trade")
public class AliPayController {
    private static final Logger log = LoggerFactory.getLogger(AliPayController.class);

   @Autowired
   OrdersService service;
    @Value("${alipay.return_url}")
    private String return_url;
    @Value("${alipay.notify_url}")
    private String notify_url;

    @Value("${alipay.pay_url}")
    private String payurl;

    @RequestMapping("/page/pay")
    public void  Pagepay(AliPayModel form, HttpServletRequest request, HttpServletResponse response) {
        //获得初始化的AlipayClient
        AlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.gatewayUrl, AlipayConfig.app_id, AlipayConfig.merchant_private_key, "json", AlipayConfig.charset, AlipayConfig.alipay_public_key, AlipayConfig.sign_type);
        String  id=UUIdUtils.createuuid();
        //设置请求参数
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        alipayRequest.setReturnUrl(return_url);
        alipayRequest.setNotifyUrl(notify_url);
        form.setProduct_code("FAST_INSTANT_TRADE_PAY");
        form.setOut_trade_no(id);
        alipayRequest.setBizContent(JsonUtil.objToStr(form));
        //若想给BizContent增加其他可选请求参数，以增加自定义超时时间参数timeout_express来举例说明
        //alipayRequest.setBizContent("{\"out_trade_no\":\""+ out_trade_no +"\","
        //		+ "\"total_amount\":\""+ total_amount +"\","
        //		+ "\"subject\":\""+ subject +"\","
        //		+ "\"body\":\""+ body +"\","
        //		+ "\"timeout_express\":\"10m\","
        //		+ "\"product_code\":\"FAST_INSTANT_TRADE_PAY\"}");
        //请求参数可查阅【电脑网站支付的API文档-alipay.trade.page.pay-请求参数】章节
        String result ="";
        //请求
        try {
             result = alipayClient.pageExecute(alipayRequest).getBody();

            //将订单新增到表中，状态为待支付
            Orders order=new Orders();
            order.setOrderNum(id);
            order.setSubject(form.getSubject());
            order.setOrderAmount(form.getTotal_amount());
            order.setOrderStatus("10");
            order.setBuyCounts(1);
            order.setCreateTime(DateUtils.getTime());
            order.setBz(form.getBody());
            order.setPayurl(result);
            service.add(order);

        }catch (AlipayApiException e) {
            log.error("page/pay->AlipayApiException：{}",e);
            if(e.getCause() instanceof java.security.spec.InvalidKeySpecException){
               result="商户私钥格式不正确，请确认配置文件Alipay-Config.properties中是否配置正确";
                ResponseUtil.ResponseStr(response, result);
            }
        }
        ResponseUtil.ResponseStr(response, "<div style='height:60px;line-height: 60px;background: #019fe9;text-align: center;color: #ffffff;font-size: 25px;'>支付平台</div>" +
                "<div style='height:calc(100% - 60px);width:100%;'>" +
                "<div style='height:210px;width:100%;color:red;text-align:center;    line-height: 200px;font-size: 20px;font-weight: 600;color: #019fe9;'>" +
                "请将如下地址复制给第三方，第三方通过浏览器打开!</div>" +
                "\n" +
                "<div style=\"text-align: center;color: #019fe9;\"  >\n" +
                "<p id=\"text\">"+payurl+"?payOrderId="+id+"</p></div>\n" +
                "<button onclick=\"copyText()\" style=\"color: #e9f5fa;  background-color: #019fe9;   float: right; margin-right:25%\">复制</button> \n" +
                "<textarea id=\"input\" style='opacity: 0;position: absolute;'></textarea>  \n" +
                " <script type=\"text/javascript\">\n" +
                " function copyText() {var text = document.getElementById(\"text\").innerText;\n" +
                "   var input = document.getElementById(\"input\");   input.value = text;   input.select();    document.execCommand(\"copy\"); alert(\"复制成功\");\n" +
                "    }  </script>");
    }

    /***
     * 取消订单
     * @param param
     * @param response
     */
    @RequestMapping("/close")
    public void  close(AliPayParam param, HttpServletResponse response) {
        //获得初始化的AlipayClient
        AlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.gatewayUrl, AlipayConfig.app_id, AlipayConfig.merchant_private_key, "json", AlipayConfig.charset, AlipayConfig.alipay_public_key, AlipayConfig.sign_type);
        //设置请求参数
        AlipayTradeCloseRequest alipayRequest = new AlipayTradeCloseRequest();
        alipayRequest.setBizContent("{\"out_trade_no\":\""+ param.getOrder_num() +"\"," +"\"trade_no\":\""+ param.getTrade_no() +"\"}");
        String result ="";
        //请求
        try {
            result = alipayClient.execute(alipayRequest).getBody();

            Orders order=new Orders();
            order.setOrderNum(param.getOrder_num());
            order.setOrderStatus("30");//取消清单
            //更新订单状态
            service.updateInfoByOrderNum(order);

        } catch (AlipayApiException e) {
            log.error("page/close->AlipayApiException：{}",e);
        }
        ResponseUtil.ResponseStr(response, result);
    }

    @RequestMapping("/query")
    @ResponseBody
    public PageResultBean<Orders> query(AliPayParam param) {
       //查询表中数据，进行数据查询
        List<Orders>  orderlist= service.queryByParam(param);
        PageInfo<Orders> rolePageInfo = new PageInfo<>(orderlist);
        return new PageResultBean<Orders>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }

    @RequestMapping("/queryPage")
    @ResponseBody
    public String  queryPage(AliPayParam param) {
        //获得初始化的AlipayClient
        AlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.gatewayUrl, AlipayConfig.app_id, AlipayConfig.merchant_private_key, "json", AlipayConfig.charset, AlipayConfig.alipay_public_key2, AlipayConfig.sign_type);
        //设置请求参数
        AlipayTradeQueryRequest alipayRequest = new AlipayTradeQueryRequest();
        alipayRequest.setBizContent("{\"out_trade_no\":\""+ param.getOrder_num() +"\","+"\"trade_no\":\""+ param.getTrade_no() +"\"}");
        String result ="";
        //请求
        try {
            result = alipayClient.execute(alipayRequest).getBody();
            Map resultmap= JsonUtil.strToObj(result, Map.class);
            if(null!=resultmap.get("alipay_trade_query_response")) {
                Map traderesult=(Map)resultmap.get("alipay_trade_query_response");
                if (null != traderesult && null != traderesult.get("msg")) {
                    result = traderesult.get("msg").toString().equals("Success")?"success":String.valueOf(traderesult.get("sub_msg"));
                }
            }

        } catch (AlipayApiException e) {
            log.error("queryPage->AlipayApiException：{}",e);
        }
        return result;
    }


}
