package com.video.ai.controller;


import com.video.ai.domain.Orders;
import com.video.ai.service.OrdersService;
import com.video.ai.utils.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;

@Controller
@RequestMapping("/")
public class IndexController {
	private static final Logger log = LoggerFactory.getLogger(IndexController.class);
	@Autowired
	OrdersService service;


	@RequestMapping("/")
	public String index() {
		return "index";
	}
	/***
	 * 查看订单详情页面
	 * @param payOrderId
	 * @param response
	 */
	@RequestMapping("/paymentPage")
	public void  paymentPage(@RequestParam(name = "payOrderId") String payOrderId, HttpServletResponse response) {
		//查询订单详情
		Orders order = service.findByOrdernum(payOrderId);
		if (null == order) {
			log.info("不存在订单号:{}的订单", payOrderId);
			ResponseUtil.ResponseStr(response, "该订单不存在");
			return;
		}
		StringBuffer result = new StringBuffer();
		result.append("<div style=\"height:60px;line-height: 60px;background: #019fe9;text-align: center;color: #ffffff;font-size: 25px;\">支付平台</div>\n" +
				"<div style=\"font-size: 18px;  color: #535353;  height: 300px;line-height: 50px; padding-top: 100px;    letter-spacing: 4px;\">\n" +
				"    <table style=\"text-align: center; width: 40%; float: right; height: 180px; border: 1px solid #019fe9; margin-right: 30%;\">\n" +
				"        <tr>\n" +
				"            <td style=\"border: 1px solid #019fe9;\">订单名称:</td>\n" +
				"            <td style=\"border: 1px solid #019fe9; color: red\">" + order.getSubject() + "</td>\n" +
				"        </tr>     <tr>\n" +
				"            <td style=\"border: 1px solid #019fe9;\">订单金额:</td>\n" +
				"            <td style=\"border: 1px solid #019fe9;color: red\">" + order.getOrderAmount() + " </td>\n" +
				"        </tr><tr>\n" +
				"            <td style=\"border: 1px solid #019fe9;\">订单描述:</td>\n" +
				"            <td style=\"border: 1px solid #019fe9;color: red\" >" + order.getBz()+ "</td>\n" +
				"        </tr>\n" +
				"    </table>\n" +
				"</div>\n" +
				"<div style=\"text-align: center;font-size: 18px;\" id=\"body\"></div>");
		result.append(order.getPayurl().replace("document.forms[0].submit();", "function countSecond(){document.getElementById(\"body\").append('正在跳转到支付界面...');setTimeout('document.forms[0].submit()', 1000)}setTimeout(\"countSecond()\", 2000)"));

		//将订单信息塞到新的 hmtl 中输出
		ResponseUtil.ResponseStr(response, result.toString());
	}

}
