package com.cx.cn.cxquartz.service.quartz.impl;

import com.cx.cn.cxquartz.bean.GoalStructureParam;
import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.bean.TaskResult;
import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.vo.ImageList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@Service
@Configuration
public class TaskRecog implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(TaskRecog.class);


    @Value("${file.recogqsturl}")
    String  recogqsturl;

    RestTemplate restTemplate=new RestTemplate();

    @Autowired
    private RabbitTemplate rabbitTemplate;


    public void sender(List<Map> list)  {

       String  result="{\n" +
                "    \"ret\": 0,\n" +
                "    \"desc\": \"succ!\",\n" +
                "    \"url\": \"http://zjh189.ncpoi.cc:7080/download/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
                "    \"resourcePath\": \"/home/ubuntu/pictures/slice/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
                "    \"timestamp\": \"2021-09-08 13:41:31.031\",\n" +
                "    \"devicecode\": \"33050300001327599605\"\n" +
                "}";
        //调用服务，10个一组批量调用分析服务
        try{
        int i=0;
        GoalStructureParam goalSparam=new GoalStructureParam();
        List<ImageList> imglist=new ArrayList<>();
        int model=1;
       Map<Integer, TaskResult> recordtypeMap=new HashMap();
        for(Map  m:list) {
            if (null != m.get("task")) {
                QuartzTaskInformations param = JsonUtil.strToObj(m.get("task").toString(), QuartzTaskInformations.class);
                Map picture = JsonUtil.strToObj(m.get("result").toString(), Map.class);
                //获得roi
                ImageList img = new ImageList();
                img.setImageID(String.valueOf(i));
                img.setFormat(2);
                if (null != param.getObjectType()) {
                    model = Integer.parseInt(param.getObjectType());
                }
                //判断是否有感兴趣区域
                if (null != param.getObjectx() && null != param.getObjecty()
                        && null != param.getObjectw() && null != param.getObjecth()) {
                    img.setRoi(new Long[]{param.getObjectx(),
                            param.getObjecty(),
                            param.getObjectw(),
                          param.getObjecth()
                    });
                }
                img.setData(picture.get("resourcePath").toString());
                imglist.add(img);
                recordtypeMap.put(i,new TaskResult(param.getVideoid(),param.getRecordtype(),
                                picture.get("timestamp").toString(),  param.getObjectx(),param.getObjecty(),
                                param.getObjectw() , param.getObjecth(),  picture.get("resourcePath").toString(),
                                param.getMetatype(), param.getSendtype(),    param.getUrl()
                        )
                        );
                i++;
            }
        }
            goalSparam.setImageList(imglist);
            goalSparam.setModel(model);
            logger.info("goalSparam:{}",JsonUtil.objToStr(goalSparam));
            String resultstr = restTemplate.postForObject(recogqsturl, goalSparam, String.class);
            logger.info("resultstr:{}",resultstr);
//            try {
                Map resulMap = JsonUtil.strToObj(resultstr, Map.class);
                if (null != resulMap.get("ret") && resulMap.get("ret").equals("200")) {
                    List<Map> resultList = (List<Map>) resulMap.get("ObjectList");
                    if (resultList.size() < 1) {
                        logger.info("  objectresult is empty");
                        return ;
                    }
                    for (Integer key : recordtypeMap.keySet()) {
                        List<Map> senderresult = new ArrayList<>();
                        //遍历所有返回结果
                        for (Map resultMap : resultList) {
                            //放到消息处理 队列中
                            //根据返回的图片id 获得告警类型
                            if (null != resultMap.get("ImageID") && resultMap.get("ImageID").toString().equals(String.valueOf(key))) {
                                senderresult.add(resultMap);
                            }
                        }
                        Map map = new HashMap();
                        map.put("ObjectList",senderresult);
                        map.put("param", recordtypeMap.get(key));
                        CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                rabbitTemplate.convertAndSend(QueueConstants.QueueEventProcessingEnum.QUEUE_EVENT_PROCESSING_ENUM.getExchange(),
                                QueueConstants.QueueEventProcessingEnum.QUEUE_EVENT_PROCESSING_ENUM.getRouteKey(),
                                MessageHelper.objToMsg(map),
                                correlationData);
                    }
                }
            } catch (Exception ex) {
                logger.error(ex.toString());
            }
        }


    @Override
    public void afterPropertiesSet() throws Exception {
//        init();
    }
}