package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 *抽帧任务
 */
@Configuration
public class TaskComsumExchangeConfig {

    /**
     * 创建交换机
     *
     * @return
     */
    @Bean
    public DirectExchange TaskConsumerDirectExchange() {
        return new DirectExchange(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange());
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue ModelDXDirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_DX", true);
    }


    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue ModelQSTDirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_QST", true);
    }
    /**
     * 将队列和交换机绑定,并设置用于匹配路由键
     *
     * @return
     */
    @Bean
    public Binding BindingQSTDirect() { return BindingBuilder.bind(ModelQSTDirectQueue()).to(TaskConsumerDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_QST");
    }

@Bean
    public Binding BindingDXDirect(){
        return BindingBuilder.bind(ModelDXDirectQueue()).to(TaskConsumerDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_DX");

}
}
