package com.cx.cn.cxquartz.controller;


import com.cx.cn.cxquartz.service.quartz.LJTMyjcResultService;
import com.cx.cn.cxquartz.vo.LJTMyjcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/***
 * 垃圾桶溢出检测等任务解析结果回调方法
 */
@RestController
@RequestMapping("/algorithm")
public class LJTController {
    private static final Logger logger = LoggerFactory.getLogger(LJTController.class);
      @Autowired
      LJTMyjcResultService lJTMYJCResultService;

    /***
     * 垃圾桶识别结果推送
     * @param result
     */
    @RequestMapping(value = "/CallBackResult", method = RequestMethod.POST)
    public void LJTMYJCResult(@RequestBody String result) {
        logger.info("LJTMYJCResult receive data:",result);
        //将数据添加到表中，直接先存储json
        LJTMyjcResult lJTMyjcResult=new LJTMyjcResult();
        lJTMyjcResult.setData(result);
        lJTMYJCResultService.insert(lJTMyjcResult);
    }
}
