package com.cx.cn.cxquartz.util;

import com.cx.cn.cxquartz.controller.ExtController;
import com.cx.cn.cxquartz.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;

public class FileTransferManager {
    private static CompletionService<TransferResult> completionService = new ExecutorCompletionService<TransferResult>(ThreadPoolUtil.getPool());
    private static CompletionService<PictureResult> threadService = new ExecutorCompletionService<PictureResult>(ThreadPoolUtil.getPool());
    private static final Logger log = LoggerFactory.getLogger(ExtController.class);
    /**
     * @param transferRecord
     * @param ftp
     * @param basePath
     * @return
     * @throws Exception
     */
    public static List<TransferResult> transferFile(final Map<String, Object> transferRecord, final Ftp ftp, final String basePath) throws Exception {
        Integer ret = 0;
        final Long recordid = Long.parseLong(transferRecord.get("recordid").toString());
        int count = 0;
        for (String key : transferRecord.keySet()) {
            if (key.equals("img1path") || key.equals("img2path")
                    || key.equals("img3path") || key.equals("img4path")
                    || key.equals("img5path")) {
                final String url = transferRecord.get(key).toString();
                count++;
                completionService.submit(() -> {
                    TransferResult result = new TransferResult(recordid, key, url, "", false);
                    try {
                        String filesuff = "videopath".equals(key) ? ".mp4" : ".jpg";
                        HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
                        connection.setReadTimeout(2000);    //延迟连接
                        connection.setConnectTimeout(3000);
                        connection.setRequestMethod("GET");
                        if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
                            InputStream inputStream = connection.getInputStream();
                            String pname = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_0000_" + key.replace("path", "");
                            String fileName = pname + filesuff;
                            String ftputl = FTPUtil.getFtpUrl(ftp) + basePath + "/" + fileName;
                            boolean r = FTPUtil.uploadFile(ftp, basePath, fileName, inputStream);
                            result.setResult(r);
                            if (r) {
                                result.setImgpath(ftputl);
                            }
//                                log.info("callable thread:" +result.toString());
                        } else {
                            log.error("connection code: " + connection.getResponseCode() + " ," + result.toString());
                        }
                    } catch (IOException e) {
                        System.out.println(e.toString());
                        log.error(e.toString());
                    }

                    return result;
                });
            }
        }
        List<TransferResult> listret = new ArrayList<>();
        for (int i = 0; i < count; i++) {
            listret.add(completionService.poll(10, TimeUnit.SECONDS).get());
        }
        return listret;
    }


    public static void fetchUrlsFromRecord(TraffAlarmRecord record, Map<String, Object> transferRecord) {
         if (record == null || record.getRecordid() == null) {
            return;
        }
        transferRecord.put("recordid", record.getRecordid());

        if (record.getImg1path() == null && record.getImg1urlfrom() != null) {
            transferRecord.put("img1path", record.getImg1urlfrom());
        }

        if (record.getImg2path() == null && record.getImg2urlfrom() != null) {
            transferRecord.put("img2path", record.getImg2urlfrom());
        }

        if (record.getImg3path() == null && record.getImg3urlfrom() != null) {
            transferRecord.put("img3path", record.getImg3urlfrom());
        }

        if (record.getImg4path() == null && record.getImg4urlfrom() != null) {
            transferRecord.put("img4path", record.getImg4urlfrom());
        }

        if (record.getImg5path() == null && record.getImg5urlfrom() != null) {
            transferRecord.put("img5path", record.getImg5urlfrom());
        }

        if (record.getVideopath() == null && record.getVideourlfrom() != null) {
            transferRecord.put("videopath", record.getVideourlfrom());
        }
    }

    public static TraffAlarmRecord traffAlarmRecordUrlUpdate(List<TransferResult> results) throws Exception {
        TraffAlarmRecord record = new TraffAlarmRecord();
        for (TransferResult result : results) {
            record.setRecordid(result.getRecordid());
            if (result.getResult()) {
                switch (result.getPathvalue()) {
                    case "img1path":
                        record.setImg1path(result.getImgpath());
                        break;
                    case "img2path":
                        record.setImg2path(result.getImgpath());
                        break;
                    case "img3path":
                        record.setImg3path(result.getImgpath());
                        break;
                    case "img4path":
                        record.setImg4path(result.getImgpath());
                        break;
                    case "img5path":
                        record.setImg5path(result.getImgpath());
                        break;
                    case "videopath":
                        record.setVideopath(result.getImgpath());
                        break;
                    default:
                        break;
                }
            }
        }
        return record;
    }

    public static GoalStructureParam getGoalStructureParam(int count,Long[] roiarray, int model, BASE64Encoder base64Encoder, TraffAlarmRecord transferRecord) {
        //获得图片进行分析
        GoalStructureParam param = new GoalStructureParam();
        param.setOutput(new Output(1, 1, -1, 3));
        param.setModel(model);
        param.setApiout("1");////打开1400标准输出，默认可以不填
        List<ImageList> list = new ArrayList<>();
        getImageList("1",roiarray, base64Encoder, list, transferRecord.getImg1path());
        getImageList("2", roiarray,base64Encoder, list, transferRecord.getImg2path());
        getImageList("3", roiarray,base64Encoder, list, transferRecord.getImg3path());
        getImageList("4",roiarray, base64Encoder, list, transferRecord.getImg4path());
        getImageList("5", roiarray,base64Encoder, list, transferRecord.getImg5path());
        param.setImageList(list);
        return  param;

    }

    private static void getImageList(String id,Long[] roiarray, BASE64Encoder base64Encoder, List<ImageList> list, String img1path) {
        if (null != img1path && !"".equals(img1path)) {
            byte[] Img = FTPUtil.getFtpPicBytes(img1path);
            if (Img != null) {
                list.add(new ImageList(id,roiarray,20,1,20,100,base64Encoder.encode(Img).replaceAll("\r|\n", "")));

            }
        }
    }


}

