package com.cx.cn.cxquartz.service.quartz;

import com.cx.cn.cxquartz.util.RedisEnum;
import com.cx.cn.cxquartz.vo.Ftp;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class FtpService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(FtpService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private List<Ftp> ftpList;
    @Autowired
    CacheLoadService cacheLoadService;
    @Autowired
    public FtpService(StringRedisTemplate stringRedisTemplate) {
//        try {
//            this.ftpList = getFtpList(stringRedisTemplate.opsForValue().get(RedisEnum.FTPLIST.getValue()));
//        }catch (Exception e){
//            logger.error("ftpList error:"+e.toString());
//        }
    }

    public Ftp reloadFtp() {
        try {
//            cacheLoadService.loadFtpCache();
            if(null==stringRedisTemplate.opsForValue().get(RedisEnum.FTPLIST.getValue())){
                cacheLoadService.loadFtpCache();
            }
            ftpList = getFtpList(stringRedisTemplate.opsForValue().get(RedisEnum.FTPLIST.getValue()));
        }catch (Exception e){
            logger.error("ftpListerror:"+e.toString());
        }

        Long count = null;
        try {
            count = stringRedisTemplate.opsForValue().increment(RedisEnum.FTPLIST_INDEX.getValue(), 1L);
        } catch (Exception e) {
            logger.error("redis error" + e.toString());
        }
        if (count == null) {
            count = 0L;
        }
        long index = count % ftpList.size();
        return ftpList.get((int) index);
    }



    private List<Ftp> getFtpList(String ftpJson) {
        try {
            JavaType javaType =OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, Map.class);
            List<Map> jsonArr = OBJECT_MAPPER.readValue(ftpJson, javaType);
            List<Ftp> ftpList = new ArrayList<>();
            for (int i = 0; i < jsonArr.size(); i++) {
                Ftp ftp = new Ftp();
                Map jsonObject = jsonArr.get(i);
                ftp.setFtpIp(jsonObject.get("serveip").toString());
                ftp.setFtpPort(Integer.parseInt(jsonObject.get("serverport")==null?"21":jsonObject.get("serverport").toString()));
                ftp.setFtpUsername(jsonObject.get("serveruser").toString());
                ftp.setFtpPassword(jsonObject.get("serverpassword").toString());
                ftpList.add(ftp);
            }
        }catch (Exception ex){
            logger.error("ftpListerror:"+ex.toString());
        }
        return ftpList;
    }
}
