package com.cx.cn.cxquartz.util;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Date;

public class DateUtils {
    private static final DateTimeFormatter YMD_HMS = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter YMDHMS = DateTimeFormat.forPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter YMD = DateTimeFormat.forPattern("yyyyMMdd");
    private static final DateTimeFormatter Y_M_D = DateTimeFormat.forPattern("yyyy-MM-dd");
    private static final DateTimeFormatter YM= DateTimeFormat.forPattern("yyyyMM");
    private static final DateTimeFormatter DD= DateTimeFormat.forPattern("dd");
    public static String formatCurrDate(){
        return formatCurrDateByType(YMD_HMS);
    }

    public static String formatCurrDateNoSign(){
        return formatCurrDateByType(YMDHMS);
    }


    public static String formatCurrDateYMD(){
        return formatCurrDateByType(Y_M_D);
    }

    public static String formatCurrDayNoSign(){
        return formatCurrDateByType(YMD);
    }

    public static String formatCurrDayYM(){
        return formatCurrDateByType(YM);
    }
    public static String formatCurrDayDD(){
        return formatCurrDateByType(DD);
    }
    public static Date parseDate(String date){
        return DateTime.parse(date,YMD_HMS).toDate();
    }
    public static Date parseMilisecondsToDate(Long time){
        return new Date(time);
    }


    public static Date parseDateNoSign(String date){
        return DateTime.parse(date,YMDHMS).toDate();
    }


    public static String parseDateToStrNoSign(String date){
        return DateTime.parse(date,YMD_HMS).toString(YMDHMS);
    }

    public static String parseDateToStrNoSign(Date date){
        return new DateTime(date).toString(YMDHMS);
    }
    public static String getYesterday(int day){
        Date date= addDay(new Date(),day);
        return new DateTime(date).toString(YMD_HMS);
    }

    public static String getlastMonth(int month){
        Date date= addMonth(new Date(),month);
        return new DateTime(date).toString(YMD_HMS);
    }

    public static String formatDate(Date date){
        return new DateTime(date).toString(YMD_HMS);
    }

    public static String formatDateToNoSign(Date date){
        return new DateTime(date).toString(YMDHMS);
    }

    public static String formatDateToNoSign(String date){
        return DateTime.parse(date,YMD_HMS).toString(YMDHMS);
    }

    private static String formatCurrDateByType(DateTimeFormatter dateTimeFormatter){
        return DateTime.now().toString(dateTimeFormatter);
    }

    public static Date addMinutes(Date date, int minutes) {
        return new DateTime(date).plusMinutes(minutes).toDate();
    }

    public static Date addDay(Date date, int day) {
        if(day == 0){
            return date;
        }
        return new DateTime(date).plusDays(day).toDate();
    }

    public static Date addMonth(Date date, int month) {
        if(month == 0){
            return date;
        }
        return new DateTime(date).plusMonths(month).toDate();
    }

    public static int diffMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        DateTime dt1 = new DateTime(date1);
        DateTime dt2 = new DateTime(date2);
        return Months.monthsBetween(dt1, dt2).getMonths();
    }

    public static int diffDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        DateTime dt1 = new DateTime(date1);
        DateTime dt2 = new DateTime(date2);
        return Days.daysBetween(dt1, dt2).getDays();
    }

    public  static String getTimeStamps(){
        return  String.valueOf(new Date().getTime());


    }

    public static  String  addMin(String datestr,int min){
        return  new DateTime(DateTime.parse(datestr,YMD_HMS)).plusMinutes(min).toString(YMD_HMS);

    }

    public static  String  addMin(Date date,int min){
        return  new DateTime(date).plusMinutes(min).toString(YMD_HMS);
    }
}
