package com.cx.cn.cxquartz.service.quartz.impl;

import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.job.WebSocket;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.service.quartz.TraffPictureService;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.vo.JobTjParam;
import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.vo.TraffpictureParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.*;

@Service
public class ResultService {

    @Autowired
    EventWriteService eventWriteService;

    @Autowired
    TraffPictureService traffPictureService;

    @Value("${file.outpath}")
    private String outpath;

    @Value("${voice.unionId}")
    private String unionId;
    @Value("${countryside.callbackurl}")
    private String callbackurl;

    @Value("${web.url}")
    private String weburl;
    @Value("${file.publicpictureurl}")
    private String publicpictureurl;

    @Value("${voice.appKey}")
    private String appKey;

    @Value("${voice.corpId}")
    private String corpId;

    @Value("${voice.eventId}")
    private Integer eventId;
    @Value("${file.rootpath}")
    private String filerootpath;

    @Autowired
    WebSocket webSocket;

    @Autowired
    RabbitTemplate rabbitTemplate;

    public static final Logger logger = LoggerFactory.getLogger(ResultService.class);
    public  void processResult( Map  result) {
        Map taskinfo= (Map) result.get("param");
        String devicecode=(String) taskinfo.get("devicecode");
        String recordtype =(String) taskinfo.get("recordtype");
        String  threshold=(String) taskinfo.get("threshold");
        String timestamp=taskinfo.get("timestamp").toString().substring(0,taskinfo.get("timestamp").toString().indexOf("."));

        JobTjParam jobTjParam = new JobTjParam();
        jobTjParam.setDeviceId(devicecode);
        jobTjParam.setDetectType(recordtype);
        String imageurl = taskinfo.get("url").toString();
        TraffpictureParam traffpictureParamresult=new TraffpictureParam();
        try {
//            Map maprecogdata = JsonUtil.strToObj(objectList.get("recogdata").toString(), Map.class);
            List<Map> points = new ArrayList<>();
            //分析结果数据
            if (null != result) {
                List<Map> objectresult = (List<Map>) result.get("ObjectList");
                if (objectresult.size() < 1) {
                    logger.info("  objectresult is empty");
                } else {
                    Long[] roiarray = new Long[4];
                    roiarray[0] = new Long(taskinfo.get("x").toString());
                    roiarray[1] = new Long(taskinfo.get("y").toString());
                    roiarray[2] = new Long(taskinfo.get("w").toString());
                    roiarray[3] = new Long(taskinfo.get("h").toString());
                    //图片划线并上传
                    String basepath = DateUtils.formatCurrDayYM() + File.separator + DateUtils.formatCurrDayDD() + File.separator + devicecode;
                    String filename = devicecode + "_" + DateUtils.parseDateToStrNoSign(timestamp) + "_result.jpg";
                    String filenameurl = File.separator + outpath + File.separator + basepath + File.separator + filename;
                    jobTjParam.setImageUrl(weburl + filenameurl);
                    traffpictureParamresult.setImagedata(filenameurl);            //获得点位
                    traffpictureParamresult = eventWriteService.getResult(traffpictureParamresult, Integer.parseInt(threshold)
                            , roiarray, imageurl, objectresult, jobTjParam, points);
                    if (null == traffpictureParamresult) {
                        logger.info("人群密度未超或目标未出现");
                    } else {
                        //同步上传文件
                        eventWriteService.uploadPicture(traffpictureParamresult, imageurl, points, basepath, filename);
                        //新增
                        eventWriteService.setTraffpictureParam(recordtype, devicecode,
                                timestamp,
                                traffpictureParamresult);
                        Map sendtodxmap = new HashMap();
                        sendtodxmap.put("id", traffpictureParamresult.getId());
                        sendtodxmap.put("traff", JsonUtil.objToStr(jobTjParam));
                        sendtodxmap.put("callback", taskinfo.get("url").equals("") ? callbackurl : taskinfo.get("url").toString());
                        CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
//                        rabbitTemplate.convertAndSend(QueueConstants.QueueSendToDXEnum.QUEUE_SEND_TO_DX_ENUM.getExchange(),
//                                QueueConstants.QueueSendToDXEnum.QUEUE_SEND_TO_DX_ENUM.getRouteKey(),
//                                MessageHelper.objToMsg(sendtodxmap),
//                                correlationData);
//
//                        rabbitTemplate.convertAndSend(QueueConstants.QueueSendToVoiceEnum.QUEUE_SEND_TO_VOICE_ENUM.getExchange(),
//                                QueueConstants.QueueSendToVoiceEnum.QUEUE_SEND_TO_VOICE_ENUM.getRouteKey(),
//                                MessageHelper.objToMsg(sendtodxmap),
//                                correlationData);
//            //回调第三方接口
////                            logger.info("send to dianxin data:{}",JSONObject.toJSONString(jobTjParam));
//            eventWriteService.sendEventByCallUrl(traffpictureParamresult, jobTjParam, taskinfo.getUrl().equals("") ? callbackurl : taskinfo.getUrl());

                    }
                }
            }

            } catch(Exception ex){
                logger.error(" processResult error:{}", ex.toString());
            }
    }


}
