package com.cx.cn.cxquartz.rabbitmq.comsumer;

import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.service.quartz.TraffAlarmRecordService;
import com.cx.cn.cxquartz.service.quartz.impl.ResultService;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;
/**
 * 消息处理并推送第三方
 */
@Component
public class EventProcessingConsumer implements BaseConsumer {
    private static final Logger logger = LoggerFactory.getLogger(EventProcessingConsumer.class);
    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;

    @Autowired
    ResultService resultService;
    /**
     * 消息消费入口
     *
     * @param message
     * @param channel
     * @throws IOException
     */
    @Override
    public void consume(Message message, Channel channel) throws IOException {
        logger.info("TaskConsumConsumer 收到消息: {}", message.toString());
        Map result = MessageHelper.msgToObj(message, Map.class);
        resultService.processResult(result);
        //if (null !=result) {
//            QuartzTaskInformations taskinfo = JsonUtil.strToObj( result.get("task").toString(),QuartzTaskInformations.class);
        //  if (null != result.get("result")) {
        //     Map objresult = JsonUtil.strToObj(result.get("result").toString(), Map.class);
                //处理消息
//                resultService.processResult(taskinfo, objresult);
        // }
    //}
    }
}
