package com.cx.cn.cxquartz.config;

import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.vo.Sbtdspsr;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.PeriodicTrigger;

import java.util.Date;
import java.util.List;
import java.util.UUID;

@Configuration
@EnableScheduling
public class PerformedTaskCornChange  implements SchedulingConfigurer {

    @Autowired
    private SbtdspsrService sbtdspsrService;

    @Autowired
    private RabbitTemplate rabbitTemplate;
    private Long timer=1000L;

    public Long getTimer() {
        return timer;
    }

    public void setTimer(Long timer) {
        this.timer = timer;
    }

    @Override
    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(new Runnable() {
            @Override
            public void run() {
                //判断最小执行时间,   // 如果小于2分钟，立即执行所有设备的获取rtsp与hls 的服务，下次执行时间为间隔2分钟
                //  如果大于2分钟，下次执行时间为间隔1秒
              Long time=  sbtdspsrService.getPeriodicseconds();
              if(time<1200){
                  setTimer(120000L);
                 List<Sbtdspsr> list= sbtdspsrService.getPerformedTasks();
                 if(null!=list && list.size()>0) {
                     for(Sbtdspsr  sbtdspsr:list) {
                         //丢到rabbitMq中
                         String msgId = UUID.randomUUID().toString();
                         CorrelationData correlationData = new CorrelationData(msgId);
                         rabbitTemplate.convertAndSend(QueueConstants.QueueRTSPEnum.QUEUE_RTSP_ENUM.getExchange(),
                                 QueueConstants.QueueRTSPEnum.QUEUE_RTSP_ENUM.getRouteKey(),
                                 MessageHelper.objToMsg(sbtdspsr),
                                 correlationData);
                     }
                 }
                 else{
            //查询所有数据



                 }

                }
              else {
                  setTimer(1000L);
              }
            }
        }, new Trigger() {
            @Override
            public Date nextExecutionTime(TriggerContext triggerContext) {
                PeriodicTrigger trigger=new PeriodicTrigger(timer);
                Date nextDate= trigger.nextExecutionTime(triggerContext);
                return nextDate;
            }
        });

    }
}
