package com.cx.cn.cxquartz.redis;

public class QueueConfiguration {

    private String queue;

    private Consumer consumer;

    public static Builder builder(){
        return new Builder();
    }

    public static class Builder{
        private QueueConfiguration configuration = new QueueConfiguration();

        public Builder queue(String queue) {
            configuration.queue = queue;
            return this;
        }

        public Builder consumer(Consumer consumer) {
            configuration.consumer = consumer;
            return this;
        }

        public QueueConfiguration build() {
            if (configuration.queue == null || configuration.queue.length() == 0) {
                if (configuration.consumer != null) {
                    configuration.queue = configuration.getClass().getSimpleName();
                }
            }
            return configuration;
        }
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public String getQueue() {
        return queue;
    }

    public Consumer getConsumer() {
        return consumer;
    }
}
