package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 视频图片直连型交换机配置
 * 1. 声明Exchange交换器；
 * 2. 声明Queue队列；
 * 3. 绑定BindingBuilder绑定队列到交换器，并设置路由键；
 * 消费者单纯的使用，其实可以不用添加这个配置，直接建后面的监听就好，使用注解来让监听器监听对应的队列即可。
 * 配置上了的话，其实消费者也是生成者的身份，也能推送该消息。
 */
@Configuration
public class TaskComsumExchangeConfig {

    /**
     * 创建交换机
     *
     * @return
     */
    @Bean
    public DirectExchange OrderCancelDirectExchange() {
        return new DirectExchange(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange());
    }

//    /**
//     * 创建队列 true表示是否持久
//     *
//     * @return
//     */
//    @Bean
//    public Queue OrderCancelDirectQueue() {
//        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue(), true);
//    }


    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue Model1DirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_1", true);
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue Model2DirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_2", true);
    }
    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue Model3DirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_3", true);
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue Model4DirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_4", true);
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue Model5DirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_5", true);
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue Model0DirectQueue() {
        return new Queue(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getQueue()+"_0", true);
    }
    /**
     * 将队列和交换机绑定,并设置用于匹配路由键
     *
     * @return
     */
    @Bean
    public Binding BindingDirect() {
        BindingBuilder.bind(Model1DirectQueue()).to(OrderCancelDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_1");
        BindingBuilder.bind(Model2DirectQueue()).to(OrderCancelDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_2");
        BindingBuilder.bind(Model3DirectQueue()).to(OrderCancelDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_3");
        BindingBuilder.bind(Model4DirectQueue()).to(OrderCancelDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_4");
        BindingBuilder.bind(Model5DirectQueue()).to(OrderCancelDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_5");
        return BindingBuilder.bind(Model0DirectQueue()).to(OrderCancelDirectExchange()).with(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_0");
    }


}
